/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.renderer.CommitId;
import com.pmease.quickbuild.plugin.report.changes.rest.RawChangeset;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.Order;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import com.pmease.quickbuild.plugin.report.engine.util.Builds;
import com.pmease.quickbuild.plugin.tracker.core.IssueCategory;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.repositorysupport.BuildChangeset;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TrackerHelper {
    private static final Pattern pIntIssueKey = Pattern.compile("\\d+");
    public static final String ISSUES_ACTIONS = "com.pmease.quickbuild.plugin.tracker.core.contribution.issueActions";
    public static final String FAILED_COMMANDS = "com.pmease.quickbuild.plugin.tracker.core.contribution.failedCommands";

    public static List<BuildChangeset> getChangesSincePreviousSuccessful(Build build) {
        Build previousBuild = build.getPreviousSuccessful();
        if (previousBuild == null) {
            Context.getLogger().info("At lease one successful build should be exist to update issues.");
            return Collections.emptyList();
        }
        return build.getChangesSince(previousBuild);
    }

    public static Long extractLong(String issue) {
        Matcher matcher = pIntIssueKey.matcher(issue);
        if (matcher.find()) {
            try {
                return Long.valueOf(matcher.group().trim());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    public static long getIssueCount(IssueCategory category, Build build) {
        if (build == null) {
            build = Context.getBuild();
        }
        if (build == null) {
            return 0L;
        }
        File dbDir = category.getReportDirOfBuild(build, "DEFAULT");
        return category.getRowsCount(dbDir, "issues");
    }

    private static Map<String, Object> getIssuesReports(String categoryId) {
        Map reports = Context.getBuild().getReports();
        HashMap map = (HashMap)reports.get(categoryId);
        if (map == null) {
            map = new HashMap();
            reports.put(categoryId, map);
        }
        return map;
    }

    public static Map<String, String> getIssueActions(ReportCategory category) {
        Map<String, Object> map = TrackerHelper.getIssuesReports(category.getId());
        HashMap issueActions = (HashMap)map.get(ISSUES_ACTIONS);
        if (issueActions == null) {
            issueActions = new HashMap();
            map.put(ISSUES_ACTIONS, issueActions);
        }
        return issueActions;
    }

    public static DataReport getFailedReport(ReportCategory category) {
        Map<String, Object> map = TrackerHelper.getIssuesReports(category.getId());
        DataReport report = (DataReport)map.get(FAILED_COMMANDS);
        if (report == null) {
            report = category.createReport("failedcommands");
            map.put(FAILED_COMMANDS, report);
        }
        return report;
    }

    public static List<Issue> getIssues(ReportCategory category, Configuration configuration, Long fromBuild, Long toBuild, int offset, int limit, boolean asc) {
        DataReport report = TrackerHelper.getIssueReport(category, configuration, fromBuild, toBuild, offset, limit, asc);
        if (report.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList issues = Lists.newArrayList();
        for (DataRow each : report.getRows()) {
            Issue issue = new Issue();
            each.toBean((Object)issue, true);
            issues.add(issue);
        }
        return issues;
    }

    public static DataReport getIssueReport(ReportCategory category, Configuration configuration, Long fromBuild, Long toBuild, int offset, int limit, boolean asc) {
        File dbDir = category.getReportDirOfStats(configuration, "DEFAULT");
        DataReport report = category.createReport("issues");
        if (!dbDir.exists()) {
            return report;
        }
        SqlBuilder query = SqlBuilder.query().select(new String[]{"*"}).from(new String[]{"issues"});
        if (fromBuild != null) {
            query.where(new Filter[]{Restrictions.ge((String)"buildId", (Object)fromBuild)});
        }
        if (toBuild != null) {
            query.where(new Filter[]{Restrictions.le((String)"buildId", (Object)toBuild)});
        }
        query.orderby(new Order[]{new Order("created", asc)});
        query.offset(offset);
        if (limit > 0) {
            query.limit(limit);
        }
        report = category.loadReport(dbDir, query);
        return report;
    }

    public static List<RawChangeset> getIssueChanges(ReportCategory category, Configuration configuration, String issueKey, Long fromBuild, Long toBuild, int offset, int limit, boolean asc) {
        File dbDir = category.getReportDirOfStats(configuration, "DEFAULT");
        if (!dbDir.exists()) {
            return Collections.emptyList();
        }
        SqlBuilder query = SqlBuilder.query().select(new String[]{"*"}).from(new String[]{"issues"});
        query.where(new Filter[]{Restrictions.eq((String)"issueKey", (Object)issueKey)});
        if (fromBuild != null) {
            query.where(new Filter[]{Restrictions.ge((String)"buildId", (Object)fromBuild)});
        }
        if (toBuild != null) {
            query.where(new Filter[]{Restrictions.le((String)"buildId", (Object)toBuild)});
        }
        query.orderby(new Order[]{new Order("buildId", true)});
        DataReport report = category.loadReport(dbDir, query);
        if (report.isEmpty()) {
            return Collections.emptyList();
        }
        DataRow row = (DataRow)Iterables.getFirst((Iterable)report.getRows(), null);
        Long actualFromBuild = row.getLong("buildId");
        row = (DataRow)Iterables.getLast((Iterable)report.getRows());
        Long actualToBuild = row.getLong("buildId");
        HashSet ids = Sets.newHashSet();
        for (DataRow each : report.getRows()) {
            List changeIds = (List)each.getValue("changeIds");
            List repositories = (List)each.getValue("repositories");
            int j = Math.min(changeIds.size(), repositories.size());
            for (int i = 0; i < j; ++i) {
                CommitId id = new CommitId((String)changeIds.get(i), (String)repositories.get(i));
                ids.add(id);
            }
        }
        List changes = ChangesHelper.getChangesets((Configuration)configuration, (Long)actualFromBuild, (Long)actualToBuild, (int)0, (int)Integer.MAX_VALUE, (boolean)asc);
        ArrayList buildIds = Lists.newArrayList();
        Iterator it = changes.iterator();
        while (it.hasNext()) {
            RawChangeset each = (RawChangeset)it.next();
            CommitId id = new CommitId();
            id.setId(each.getId());
            id.setRepository(each.getRepositoryName());
            if (ids.contains(id)) {
                buildIds.add(each.getBuildId());
                continue;
            }
            it.remove();
        }
        limit = limit > 0 ? limit : changes.size();
        int toIndex = Math.min(limit, changes.size());
        return Lists.newArrayList(changes.subList(offset, toIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<BuildFragment> getIssueBuilds(IssueCategory category, Configuration configuration, String issueKey, int size) {
        File dir = category.getReportDirOfStats(configuration, "DEFAULT");
        if (!dir.exists()) {
            return Collections.emptyList();
        }
        CategoryDb db = category.getCategoryDb(dir);
        try {
            db.open(DbStore.Mode.READ_ONLY, "TrackerHelper::getIssueBuilds");
            SqlBuilder query = SqlBuilder.query().select(new String[]{"buildId"}).from(new String[]{"issues"}).where(new Filter[]{Restrictions.eq((String)"issueKey", (Object)issueKey)});
            List results = db.queryForArrayList(query);
            ArrayList ids = Lists.newArrayList();
            for (Object[] each : results) {
                Long id = (Long)each[0];
                if (ids.contains(id)) continue;
                ids.add(id);
            }
            Collections.sort(ids);
            Builds builds = BuildUtils.getBuilds((List)ids, (int)size);
            return builds;
        }
        finally {
            db.close();
        }
    }
}

