/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.utils;

import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class StringHelper {
    public static String[] commandLineToArgs(String command) {
        String[] list = StringHelper.splitCsvData(command, " +", "\"");
        for (int i = 0; i < list.length; ++i) {
            list[i] = StringHelper.stripQuotes(list[i], '\"');
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getOptionsFromDefinition(String definition) {
        CaseInsensitiveMap attributes = CaseInsensitiveMap.create();
        if (StringUtils.isEmpty((String)definition)) {
            return attributes;
        }
        InputStreamReader coverter = new InputStreamReader(IOUtils.toInputStream((String)definition));
        BufferedReader in = new BufferedReader(coverter);
        try {
            String line = "";
            boolean lineContinued = false;
            String opt = "";
            String value = "";
            while ((line = in.readLine()) != null) {
                if (StringUtils.isEmpty((String)(line = line.trim())) || line.startsWith("#")) continue;
                if (lineContinued) {
                    if ((value = value + "\n" + line).endsWith("\\")) {
                        value = value.substring(0, value.length() - 1);
                        continue;
                    }
                    attributes.put(opt, (Object)value);
                    lineContinued = false;
                    continue;
                }
                int pos = line.indexOf(61);
                if (pos <= 0) continue;
                opt = line.substring(0, pos).trim();
                value = line.substring(pos + 1).trim();
                if (value.endsWith("\\")) {
                    value = value.substring(0, value.length() - 1);
                    lineContinued = true;
                    continue;
                }
                attributes.put(opt, (Object)value);
            }
            if (lineContinued && !StringUtils.isEmpty((String)opt)) {
                attributes.put(opt, (Object)value);
            }
        }
        catch (IOException e) {
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
        return attributes;
    }

    public static String optionsToArgsLine(Map<String, String> attributes) {
        if (attributes.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String attr : attributes.keySet()) {
            sb.append("--").append((Object)attr).append(" \"").append(attributes.get(attr)).append("\"").append(" ");
        }
        return sb.toString();
    }

    public static String definitionToArgsLine(String definition) {
        Map<String, String> options = StringHelper.getOptionsFromDefinition(definition);
        return StringHelper.optionsToArgsLine(options);
    }

    public static String stripEnd(String str, String stripChars) {
        int end = StringHelper.getStripEnd(str, stripChars);
        return end < 0 ? str : str.substring(0, end);
    }

    private static int getStripEnd(String str, String stripChars) {
        int end;
        if (str == null || (end = str.length()) == 0) {
            return -1;
        }
        if (stripChars == null) {
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        } else {
            if (stripChars.length() == 0) {
                return end;
            }
            while (end != 0 && stripChars.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
        }
        return end;
    }

    public static String normalizeUrl(String url) {
        return StringHelper.stripEnd(url, "/\\");
    }

    public static String quoteString(String original) {
        if (StringUtils.isEmpty((String)original)) {
            return "";
        }
        String result = original.trim();
        if (StringUtils.isEmpty((String)result)) {
            return "";
        }
        if (result.charAt(0) != '\"') {
            result = '\"' + result;
        }
        if (result.charAt(result.length() - 1) != '\"') {
            result = result + '\"';
        }
        return result;
    }

    public static String stripLeadingHyphens(String str) {
        if (str == null) {
            return null;
        }
        if (str.startsWith("--")) {
            return str.substring(2, str.length());
        }
        if (str.startsWith("-")) {
            return str.substring(1, str.length());
        }
        return str;
    }

    public static String stripLeadingAndTrailingQuotes(String str) {
        if (str.startsWith("\"")) {
            str = str.substring(1, str.length());
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String[] splitCsvData(String data, String delimiter, String quote) {
        String[] values;
        Pattern pattern;
        String eolString = "\n";
        String patternString = "(?:^|" + delimiter + ")(?=(?:[^" + quote + "]*" + quote + "[^" + quote + "]*" + quote + ")*(?![^" + quote + "]*" + quote + "))";
        String tempDelimiter = delimiter;
        if (delimiter.equals("\\|")) {
            tempDelimiter = "|";
        }
        if (delimiter.length() == 1) {
            pattern = Pattern.compile("\n" + delimiter);
            Matcher matcher = pattern.matcher(data);
            data = matcher.replaceAll("\n " + tempDelimiter);
        }
        if ((values = (pattern = Pattern.compile(patternString, 8)).split(data)).length > 1) {
            String[] values2 = new String[values.length - 1];
            System.arraycopy(values, 1, values2, 0, values.length - 1);
            return values2;
        }
        return values;
    }

    public static String stripQuotes(String inString, char quote) {
        String string = inString.trim();
        if (StringHelper.isSurrounded(inString, quote)) {
            String quoteString = Character.toString(quote);
            return string.substring(1, string.length() - 1).replace(quoteString + quoteString, quoteString);
        }
        return string;
    }

    public static boolean isSurrounded(String inString, char character) {
        String string = inString.trim();
        return string.length() > 1 && string.charAt(0) == character && string.charAt(string.length() - 1) == character;
    }
}

