/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.utils;

import com.google.common.base.Strings;
import com.pmease.quickbuild.QuickbuildException;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import javax.ws.rs.core.UriBuilder;

public class RestClientFactory {
    private static Client client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Client createClient() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Client client = null;
        try {
            Thread.currentThread().setContextClassLoader(RestClientFactory.class.getClassLoader());
            client = Client.create();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        if (client == null) {
            throw new QuickbuildException("Unable to create Jersey client.");
        }
        return client;
    }

    public static synchronized Client getClient() {
        if (client == null) {
            client = RestClientFactory.createClient();
        }
        return client;
    }

    public static WebResource resource(String url, String userName, String password) {
        WebResource resource = RestClientFactory.getClient().resource(url);
        if (!Strings.isNullOrEmpty((String)userName)) {
            resource.addFilter((ClientFilter)new HTTPBasicAuthFilter(userName, password != null ? password : ""));
        }
        return resource;
    }

    public static WebResource resource(String urlBase, String path, String userName, String password) {
        WebResource resource = RestClientFactory.getClient().resource(UriBuilder.fromPath((String)urlBase).path(path).build(new Object[0]));
        if (!Strings.isNullOrEmpty((String)userName)) {
            resource.addFilter((ClientFilter)new HTTPBasicAuthFilter(userName, password != null ? password : ""));
        }
        return resource;
    }
}

