/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.step.issueupdater;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommitCommand;
import com.pmease.quickbuild.plugin.tracker.core.step.issueupdater.AbstractScmIssueUpdater;
import com.pmease.quickbuild.repositorysupport.BuildChangeset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public abstract class AbstractScmTaskUpdater
extends AbstractScmIssueUpdater {
    private static final long serialVersionUID = 1L;
    protected transient AbstractIssueTracker tracker;
    protected transient CommitCommand currentCommand;

    protected abstract AbstractIssueTracker getTracker();

    protected abstract void executeCommand();

    @Override
    protected void onBeforeUpdate() {
        super.onBeforeUpdate();
        this.tracker = this.getTracker();
    }

    @Override
    public void processChangeset() {
        BuildChangeset change = this.currentChangeset;
        Set tasks = change.getClosedTasks();
        HashSet<String> issueKeys = new HashSet<String>();
        for (String task : tasks) {
            List<String> keysInTask = this.tracker.extractIssueKeys(task);
            issueKeys.addAll(keysInTask);
        }
        if (issueKeys.isEmpty()) {
            return;
        }
        for (String each : issueKeys) {
            this.issueActions.put(each, this.getAction());
            this.currentCommand = this.createCommand(each);
            this.updateIssue();
        }
    }

    protected String getAction() {
        return "closeIssue";
    }

    protected CommitCommand createCommand(String issueKey) {
        CommitCommand command = new CommitCommand(issueKey, this.getAction());
        command.setCommitter(this.currentChangeset.getUser());
        command.setDate(this.currentChangeset.getDate());
        command.setOptions((Map<String, String>)CaseInsensitiveMap.create(new HashMap(), (Map)this.extraAttributes));
        return command;
    }

    protected void updateIssue() {
        Logger logger = Context.getLogger();
        try {
            this.executeCommand();
            this.updatedIssues.add(this.currentCommand.getIssue());
        }
        catch (TrackerException e) {
            if (logger.isDebugEnabled()) {
                logger.error("Failed update issue '" + this.currentCommand.getIssue() + "' found in SCM finished tasks.", (Throwable)e);
            } else {
                logger.error("Failed update issue '" + this.currentCommand.getIssue() + "' found in SCM finished tasks due to " + e.getMessage());
            }
            this.addFailedCommand(this.currentCommand.getIssue(), this.currentCommand.toString(), e.getMessage());
        }
    }
}

