/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.step.issueupdater;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.tracker.core.setting.AbstractTrackerSetting;
import com.pmease.quickbuild.plugin.tracker.core.setting.TrackerUserSetting;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractUpdateIssueStep;
import com.pmease.quickbuild.plugin.tracker.core.step.issueupdater.IssueUpdater;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.repositorysupport.BuildChangeset;
import com.pmease.quickbuild.repositorysupport.Repository;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public abstract class AbstractScmIssueUpdater
implements IssueUpdater {
    private static final long serialVersionUID = 1L;
    protected transient BuildChangeset currentChangeset;
    protected transient DataReport failedReport;
    protected transient Map<String, String> issueActions;
    protected transient Map<String, String> extraAttributes;
    protected transient AbstractTrackerSetting trackerSetting;
    protected transient Set<String> updatedIssues;
    protected transient AbstractUpdateIssueStep step;

    protected abstract void processChangeset();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(AbstractUpdateIssueStep step) {
        this.step = step;
        Build build = Context.getBuild();
        List<BuildChangeset> changes = TrackerHelper.getChangesSincePreviousSuccessful(build);
        Logger logger = Context.getLogger();
        if (changes.isEmpty()) {
            logger.info("No changes found since previous successful build");
            return;
        }
        try {
            this.onBeforeUpdate();
            Iterator<BuildChangeset> i$ = changes.iterator();
            while (i$.hasNext()) {
                BuildChangeset change;
                this.currentChangeset = change = i$.next();
                this.processChangeset();
            }
        }
        finally {
            this.onAfterUpdate();
        }
    }

    protected void onBeforeUpdate() {
        this.failedReport = this.step.getFailedReport();
        this.issueActions = this.step.getIssueActions();
        this.extraAttributes = StringHelper.getOptionsFromDefinition(this.step.getExtraAttributes());
        this.updatedIssues = new HashSet<String>();
        this.trackerSetting = this.step.getTrackerSetting();
    }

    protected void onAfterUpdate() {
    }

    protected void addFailedCommand(String issueKey, String cmdLine, String cause) {
        DataRow row = this.failedReport.addRow();
        row.setValue("dummyId", (Object)this.failedReport.getRowsCount());
        row.setValue("changeId", (Object)this.currentChangeset.getId());
        row.setValue("repository", (Object)this.currentChangeset.getRepositoryName());
        row.setValue("issueKey", (Object)issueKey);
        row.setValue("committer", (Object)this.currentChangeset.getUser());
        row.setValue("command", (Object)cmdLine);
        row.setValue("cause", (Object)cause);
    }

    public String getCurrentTrackerAccount() {
        return this.getTrackerUser(this.currentChangeset);
    }

    protected String getTrackerUser(BuildChangeset change) {
        Repository repository = Context.getBuild().getRepository(change.getRepositoryName());
        String committer = change.getUser();
        UserManager um = (UserManager)Quickbuild.getInstance(UserManager.class);
        if (StringUtils.isEmpty((String)committer)) {
            return null;
        }
        User u = null;
        String username = repository.getUserName(committer);
        if (StringUtils.isEmpty((String)username)) {
            return null;
        }
        u = um.get(username);
        if (u == null) {
            return null;
        }
        TrackerUserSetting userSetting = (TrackerUserSetting)PluginSettingHelper.getUserSetting(this.step.getPluginClass(), (User)u, (boolean)true);
        String tuser = null;
        if (userSetting != null) {
            tuser = userSetting.getUsername();
        }
        if (StringUtils.isEmpty(tuser)) {
            tuser = u.getName();
        }
        return tuser;
    }

    public String getCurrentCommitter() {
        return this.currentChangeset.getUser();
    }
}

