/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.step.issueupdater;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommitCommand;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.setting.AbstractTrackerSetting;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractUpdateIssueStep;
import com.pmease.quickbuild.plugin.tracker.core.step.issueupdater.IssueUpdater;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public abstract class AbstractIssueListUpdater
implements IssueUpdater {
    private static final long serialVersionUID = 1L;
    protected transient AbstractUpdateIssueStep step;
    protected transient Map<String, String> attributes;

    protected abstract Set<String> getIssueKeys();

    protected abstract Issue getIssue(String var1);

    protected abstract void updateIssue(String var1, Map<String, String> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(AbstractUpdateIssueStep step) {
        this.step = step;
        Set<String> issueKeys = this.getIssueKeys();
        if (issueKeys == null || issueKeys.isEmpty()) {
            return;
        }
        AbstractTrackerSetting setting = step.getTrackerSetting();
        DataReport failedReport = step.getFailedReport();
        Map<String, String> issueActions = step.getIssueActions();
        Logger logger = Context.getLogger();
        this.attributes = this.getUpdateAttributes();
        try {
            this.onBeforeUpdate();
            for (String each : issueKeys) {
                CommitCommand command = new CommitCommand(each, this.getUpdateAction());
                command.setOptions(this.attributes);
                try {
                    Issue issue = this.getIssue(each);
                    if (issue == null) {
                        logger.warn("Issue '" + each + "' does not exist in server " + setting.getHost() + ".");
                        continue;
                    }
                    issueActions.put(each, this.getUpdateAction());
                    if (!this.needUpdate(issue)) {
                        logger.debug("Updating issue [" + issue.getIssueKey() + "] ignored due to not matching updating condition ");
                        continue;
                    }
                    this.updateIssue(each, this.attributes);
                }
                catch (TrackerException e) {
                    if (logger.isDebugEnabled()) {
                        logger.warn("Ignore updating issue " + each + ".", (Throwable)e);
                    } else {
                        logger.warn("Ignore updating issue " + each + " due to " + e.getMessage());
                    }
                    DataRow row = failedReport.addRow();
                    row.setValue("dummyId", (Object)row.getId());
                    row.setValue("changeId", (Object)"");
                    row.setValue("committer", (Object)setting.getUser());
                    row.setValue("issueKey", (Object)each);
                    row.setValue("command", (Object)command.toString());
                    row.setValue("cause", (Object)e.getMessage());
                }
            }
        }
        finally {
            this.onAfterUpdate();
        }
    }

    protected boolean needUpdate(Issue issue) {
        return !this.attributes.isEmpty();
    }

    protected Map<String, String> getUpdateAttributes() {
        return StringHelper.getOptionsFromDefinition(this.step.getExtraAttributes());
    }

    protected void onBeforeUpdate() {
    }

    protected void onAfterUpdate() {
    }

    protected String getUpdateAction() {
        return "update";
    }
}

