/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.step.issueupdater;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommandParser;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommitCommand;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommitCommandDef;
import com.pmease.quickbuild.plugin.tracker.core.step.issueupdater.AbstractScmIssueUpdater;
import com.pmease.quickbuild.repositorysupport.BuildChangeset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public abstract class AbstractCommitCommandUpdater
extends AbstractScmIssueUpdater {
    private static final long serialVersionUID = 1L;
    protected transient CommitCommand currentCommand;
    protected transient AbstractIssueTracker tracker;
    protected transient Pattern pCommand;
    protected transient Pattern pIssue;

    protected abstract List<? extends CommitCommandDef> getCommitCommandDefs();

    protected abstract void initCommandDefs();

    protected abstract void executeCommand();

    protected abstract AbstractIssueTracker createTracker();

    public AbstractCommitCommandUpdater() {
        this.initCommandDefs();
    }

    protected CommitCommandDef getCommandDef(String action) {
        for (CommitCommandDef commitCommandDef : this.getCommitCommandDefs()) {
            if (!commitCommandDef.getCommand().equalsIgnoreCase(action)) continue;
            return commitCommandDef;
        }
        return null;
    }

    @Override
    protected void onBeforeUpdate() {
        super.onBeforeUpdate();
        this.tracker = this.createTracker();
        this.pCommand = this.getCommandPattern();
        this.pIssue = this.tracker.getIssuePattern();
    }

    @Override
    public void processChangeset() {
        BuildChangeset change = this.currentChangeset;
        List<CommitCommand> commands = CommandParser.extractCommands(change.getComment(), this.pCommand, this.pIssue);
        if (commands.isEmpty()) {
            return;
        }
        Logger logger = Context.getLogger();
        for (CommitCommand each : commands) {
            CommitCommandDef def = this.getCommandDef(each.getAction());
            if (def == null) continue;
            each.setDate(change.getDate());
            each.setCommitter(change.getUser());
            each.setIssue(this.tracker.extractIssueKey(each.getIssue()));
            this.currentCommand = each;
            this.mergeCommandOptions(def);
            this.issueActions.put(each.getIssue(), each.getAction());
            try {
                this.executeCommand();
                this.updatedIssues.add(each.getIssue());
            }
            catch (TrackerException e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("Ignore commit command [" + each + "].", (Throwable)e);
                } else {
                    logger.warn("Ignore commit command [" + each + "] due to " + e.getMessage());
                }
                this.addFailedCommand(this.currentCommand.getIssue(), this.currentCommand.toString(), e.getMessage());
            }
        }
    }

    protected Pattern getCommandPattern() {
        Set<String> actions = this.getAllCommandNames();
        StringBuffer sb = new StringBuffer();
        sb.append("(?<=\\(|^|\\s)(");
        if (actions == null || actions.isEmpty()) {
            throw new QuickbuildException("At least one valid command should be defined for update issue step.");
        }
        int i = 0;
        for (String action : actions) {
            sb.append(action);
            if (i + 1 < actions.size()) {
                sb.append("|");
            }
            ++i;
        }
        sb.append(")\\b");
        return Pattern.compile(sb.toString(), 2);
    }

    protected Set<String> getAllCommandNames() {
        List<? extends CommitCommandDef> defs = this.getCommitCommandDefs();
        HashSet<String> commands = new HashSet<String>();
        for (CommitCommandDef commitCommandDef : defs) {
            commands.add(commitCommandDef.getCommand());
        }
        return commands;
    }

    protected void mergeCommandOptions(CommitCommandDef mapping) {
        CommitCommand command = this.getCurrentCommand();
        CaseInsensitiveMap options = mapping.getCommandOptions();
        for (String opt : options.keySet()) {
            if (command.hasOption(opt)) continue;
            command.addOption(opt, (String)options.get(opt));
        }
        options = CaseInsensitiveMap.create(new HashMap(), (Map)this.extraAttributes);
        for (String opt : options.keySet()) {
            if (command.hasOption(opt)) continue;
            command.addOption(opt, (String)options.get(opt));
        }
    }

    public CommitCommand getCurrentCommand() {
        return this.currentCommand;
    }
}

