/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.step;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommitCommand;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.IssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractIssueStep;
import com.pmease.quickbuild.plugin.tracker.core.step.issueprovider.IssueProvider;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public abstract class AbstractReleaseVersionStep
extends AbstractIssueStep {
    private static final long serialVersionUID = 1L;
    protected transient Map<String, String> attributes;

    protected abstract void releaseVersion();

    protected abstract void updateIssue(String var1);

    protected abstract List<IssueProvider> getProviders();

    protected abstract IssueTracker getIssueTracker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.onBeforeRun();
            this.onBeforeRelease();
            this.release();
        }
        finally {
            this.onAfterRelease();
            this.onAfterRun();
        }
    }

    protected void onBeforeRelease() {
        this.attributes = StringHelper.getOptionsFromDefinition(this.getExtraAttributes());
    }

    protected void onAfterRelease() {
    }

    @ScriptApi(value="Get all issue keys to be updated.")
    public Set<String> getIssueKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (IssueProvider each : this.getProviders()) {
            keys.addAll(each.getIssueKeys());
        }
        return keys;
    }

    @ScriptApi(value="Get all issues to be updated.")
    public Collection<Issue> getIssues() {
        IssueTracker tracker = this.getIssueTracker();
        return tracker.fetchIssues(this.getIssueKeys()).values();
    }

    protected void release() {
        this.releaseVersion();
        HashSet<String> issues = new HashSet<String>();
        for (IssueProvider each : this.getProviders()) {
            issues.addAll(each.getIssueKeys());
        }
        for (String key : issues) {
            this.issueActions.put(key, "fixVersion");
            try {
                this.updateIssue(key);
            }
            catch (TrackerException e) {
                Logger logger = Context.getLogger();
                CommitCommand command = new CommitCommand(key, "update::fixVersion");
                command.setOptions(this.attributes);
                if (logger.isDebugEnabled()) {
                    logger.error("Failed to update issue [" + key + "].", (Throwable)e);
                } else {
                    logger.error("Failed to update issue [" + key + "] due to  " + e.getMessage());
                }
                this.addFailedCommand(command, e.getMessage());
            }
        }
    }

    protected void addFailedCommand(CommitCommand command, String cause) {
        DataRow row = this.failedReport.addRow();
        row.setValue("dummyId", (Object)row.getId());
        row.setValue("changeId", (Object)"");
        row.setValue("committer", (Object)this.trackerSetting.getUser());
        row.setValue("issueKey", (Object)command.getIssue());
        row.setValue("command", (Object)command.toString());
        row.setValue("cause", (Object)cause);
    }
}

