/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.step;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.setting.AbstractTrackerSetting;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.Map;

public abstract class AbstractIssueStep
extends Step {
    private static final long serialVersionUID = 1L;
    protected transient AbstractTrackerSetting trackerSetting;
    protected transient DataReport failedReport;
    protected transient Map<String, String> issueActions;
    protected String extraAttributes;

    public Class<? extends AbstractTrackerPlugin> getPluginClass() {
        return PluginManager.instance.getDeclaringPlugin(((Object)((Object)this)).getClass()).getClass();
    }

    protected void onBeforeRun() {
        this.trackerSetting = this.internalGetTrackerSetting();
        this.failedReport = TrackerHelper.getFailedReport(this.getCategory());
        this.issueActions = TrackerHelper.getIssueActions(this.getCategory());
    }

    protected void onAfterRun() {
    }

    protected ReportCategory getCategory() {
        return ReportHelper.getCategory(this.getPluginClass());
    }

    protected AbstractTrackerSetting internalGetTrackerSetting() {
        Configuration c = Context.getConfiguration();
        if (c == null) {
            throw new IllegalArgumentException("Configuration should be specified before getting issue tracker setting.");
        }
        return (AbstractTrackerSetting)PluginSettingHelper.findConfigurationSetting(this.getPluginClass(), (Configuration)c, (boolean)true);
    }

    @Editable(order=6000, name="Extra Attributes", description="Specify extra attributes of the issue, with one attribute per line. For example:<br/><code>field_1=value1<br/>field2=value2</code>Consult your issue tracker administrator for available attributes.")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get extra attributes.")
    public String getExtraAttributes() {
        return this.extraAttributes;
    }

    public void setExtraAttributes(String extraOptions) {
        this.extraAttributes = extraOptions;
    }

    public AbstractTrackerSetting getTrackerSetting() {
        return this.trackerSetting;
    }

    public void setTrackerSetting(AbstractTrackerSetting trackerSetting) {
        this.trackerSetting = trackerSetting;
    }

    public DataReport getFailedReport() {
        return this.failedReport;
    }

    public void setFailedReport(DataReport failedReport) {
        this.failedReport = failedReport;
    }

    public Map<String, String> getIssueActions() {
        return this.issueActions;
    }

    public void setIssueActions(Map<String, String> issueActions) {
        this.issueActions = issueActions;
    }
}

