/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.changes.rest.RawChangeset;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.ReportGroup;
import com.pmease.quickbuild.plugin.report.engine.datastore.Order;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.rest.BaseReportRest;
import com.pmease.quickbuild.plugin.report.engine.rest.ParamHelp;
import com.pmease.quickbuild.plugin.report.engine.rest.ParamType;
import com.pmease.quickbuild.plugin.report.engine.rest.ParamsHelp;
import com.pmease.quickbuild.plugin.report.engine.rest.RestHelp;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.tracker.core.IssueCategory;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrackerResource
extends BaseReportRest {
    private static final Logger logger = LoggerFactory.getLogger(TrackerResource.class);

    protected IssueCategory getCategory() {
        return (IssueCategory)super.getCategory();
    }

    List<Filter> getFilters(Long fromId, Long toId) {
        ArrayList filters = Lists.newArrayList();
        if (fromId != null) {
            filters.add(Restrictions.ge((String)"buildId", (Object)fromId));
        }
        if (toId != null) {
            filters.add(Restrictions.le((String)"buildId", (Object)toId));
        }
        return filters;
    }

    protected void checkPermission(Configuration c) {
        if (!SecurityHelper.hasPermission((Configuration)c, (String)"VIEW_ISSUES")) {
            throw new AccessDeniedException("You have no 'VIEW_ISSUE' permission to access configuration " + c.getPathName());
        }
    }

    @Path(value="/size/{configuration: .*}")
    @RestHelp(value="Fetch the count of issues of a specific build or a build range of the configuration.")
    @Produces(value={"text/plain"})
    @ParamsHelp(value={@ParamHelp(name="configuration", type=ParamType.PATH_PARAM, required=true, description="Specify the configuration id or configuration path, for example, 20 for configuration id or root/QuickBuild/Release for configuration path."), @ParamHelp(name="build", description="The id of a specific build."), @ParamHelp(name="from_build", description="Specify the from build when finding changes in a build range."), @ParamHelp(name="to_build", description="Specify the to build when finding changes in a build range. ")})
    @GET
    public long getSize(@PathParam(value="configuration") String configuration, @QueryParam(value="build") Long buildId, @QueryParam(value="from_build") Long fromId, @QueryParam(value="to_build") Long toId) {
        Configuration c = this.getConfiguration(configuration);
        IssueCategory category = this.getCategory();
        File dbDir = category.getReportDirOfStats(c, "DEFAULT");
        if (buildId != null) {
            return category.getRowsCount(dbDir, "issues", this.getFilters(buildId, buildId));
        }
        return category.getRowsCount(dbDir, "issues", this.getFilters(fromId, toId));
    }

    @Path(value="/issues/{configuration: .*}")
    @Produces(value={"text/xml"})
    @RestHelp(value="Fetch issues of a specific build or a build range of the configuration.")
    @ParamsHelp(value={@ParamHelp(name="configuration", type=ParamType.PATH_PARAM, required=true, description="Specify the configuration id or configuration path, for example, 20 for configuration id or root/QuickBuild/Release for configuration path."), @ParamHelp(name="build", description="Specify the build id you want."), @ParamHelp(name="from_build", description="Specify the from build when finding changes in a build range."), @ParamHelp(name="to_build", description="Specify the to build when finding changes in a build range. "), @ParamHelp(name="offset", description="Specify the first record when iterate the records, by default, the offset is 0"), @ParamHelp(name="limit", description="Specify the total records you want to retrieve, by default, the limit is 50"), @ParamHelp(name="asc", description="Boolean type, specify order by issue key ascendent or descendent, by default, it is ascendent.")})
    @GET
    public String getIssues(@PathParam(value="configuration") String configuration, @QueryParam(value="build") Long buildId, @QueryParam(value="from_build") Long fromId, @QueryParam(value="to_build") Long toId, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="asc") Boolean asc) {
        Configuration c = this.getConfiguration(configuration);
        IssueCategory category = this.getCategory();
        File dbDir = category.getReportDirOfStats(c, "DEFAULT");
        DataReport report = category.createReport("issues");
        if (!dbDir.exists()) {
            return report.toXML().asXML();
        }
        SqlBuilder query = SqlBuilder.query().select(new String[]{"*"}).from(new String[]{"issues"});
        if (buildId != null) {
            query.where(new Filter[]{Restrictions.eq((String)"buildId", (Object)buildId)});
        } else {
            query.where(this.getFilters(fromId, toId));
        }
        if (asc == null) {
            asc = true;
        }
        query.orderby(new Order[]{new Order("created", asc.booleanValue())});
        query.offset(offset);
        if (limit > 0) {
            query.limit(limit);
        } else {
            query.limit(50);
        }
        report = category.loadReport(dbDir, query);
        return report.toXML().asXML();
    }

    @Path(value="/{key}/changes/{configuration: .*}")
    @RestHelp(value="Retrieve changes of an issue.")
    @ParamsHelp(value={@ParamHelp(name="configuration", type=ParamType.PATH_PARAM, required=true, description="Specify the configuration id or configuration path, for example, 20 for configuration id or root/QuickBuild/Release for configuration path."), @ParamHelp(name="key", type=ParamType.PATH_PARAM, description="The issue key you want to search."), @ParamHelp(name="count", description="Specify at most how many records you want. If not specified, all records found will return.")})
    @GET
    public List<RawChangeset> getIssueChanges(@PathParam(value="configuration") String configuration, @PathParam(value="key") String issueKey, @QueryParam(value="count") int maxSize) {
        Configuration c = this.getConfiguration(configuration);
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieve issue [" + issueKey + "] changes from configuration [" + c.getPathName() + "].");
        }
        if (!SecurityHelper.hasPermission((Configuration)c, (String)ConfigurationPermission.ACCESS_BUILD_CHANGES.name())) {
            throw new AccessDeniedException("You have no 'ACCESS_BUILD_CHANGES' permission to access configuration: " + configuration);
        }
        List<RawChangeset> changes = TrackerHelper.getIssueChanges(this.getCategory(), c, issueKey, null, null, 0, maxSize, false);
        return changes;
    }

    @Path(value="/{key}/builds/{configuration: .*}")
    @GET
    @RestHelp(value="Retrieve the builds related to an issue specified.")
    @ParamsHelp(value={@ParamHelp(name="configuration", type=ParamType.PATH_PARAM, required=true, description="Specify the configuration id or configuration path, for example, 20 for configuration id or root/QuickBuild/Release for configuration path."), @ParamHelp(name="key", type=ParamType.PATH_PARAM, description="The issue key. If specified, the builds related to this issue will return."), @ParamHelp(name="count", description="Specify at most how many records you want. If not specified, all records found will return.")})
    public List<BuildFragment> getIssueBuilds(@PathParam(value="configuration") String configuration, @PathParam(value="key") String issueKey, @QueryParam(value="count") int maxSize) {
        Configuration c = this.getConfiguration(configuration);
        if (Strings.isNullOrEmpty((String)issueKey)) {
            return ReportUtils.getLatestBuilds((Configuration)c, (int)maxSize);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Retrieve issue [" + issueKey + "] builds from configuration [" + c.getPathName() + "].");
        }
        if (!SecurityHelper.hasPermission((Configuration)c)) {
            throw new AccessDeniedException();
        }
        if (maxSize == 0) {
            maxSize = 50;
        }
        return new ArrayList<BuildFragment>(TrackerHelper.getIssueBuilds(this.getCategory(), c, issueKey, maxSize));
    }

    @Path(value="/builds/{configuration: .*}")
    @RestHelp(value="Retrive the basic build information for a specified configuration")
    @ParamsHelp(value={@ParamHelp(name="configuration", type=ParamType.PATH_PARAM, required=true, description="Specify the configuration id or configuration path, for example, 20 for configuration id or root/QuickBuild/Release for configuration path."), @ParamHelp(name="ids", type=ParamType.QUERY_PARAM, description="A comma separated build ids"), @ParamHelp(name="count", description="Specify at most how many records you want. If not specified, all records found will return.")})
    @GET
    public List<BuildFragment> getBuilds(@PathParam(value="configuration") String configuration, @QueryParam(value="ids") String ids, @QueryParam(value="count") int size) {
        String[] tokens;
        Configuration c = this.getConfiguration(configuration);
        if (Strings.isNullOrEmpty((String)ids)) {
            return BuildUtils.getLatestBuilds((Configuration)c, (int)size);
        }
        ArrayList buildIds = Lists.newArrayList();
        for (String each : tokens = ReportUtils.splitCsv((String)ids)) {
            buildIds.add(Long.valueOf(each));
        }
        return Lists.newArrayList((Iterable)BuildUtils.getBuilds((List)buildIds, (int)size));
    }

    public List<String> getReportNames() {
        throw TrackerResource.buildException((int)405, (String)"The function is not available.");
    }

    public String getMeta(@PathParam(value="name") String name) {
        throw TrackerResource.buildException((int)405, (String)"The function is not available.");
    }

    public List<String> getReportSets(@PathParam(value="report_group") ReportGroup group, @PathParam(value="configuration_or_build_id") Long id) {
        throw TrackerResource.buildException((int)405, (String)"The function is not available.");
    }

    public Long size(@PathParam(value="name") String name, @PathParam(value="configuration_or_build_id") Long id, @PathParam(value="reportset") String reportset, @Context UriInfo ui) {
        throw TrackerResource.buildException((int)405, (String)"The function is not available.");
    }

    public String getReportRecords(@PathParam(value="configuration_or_build_id") Long id, @PathParam(value="reportset") String reportset, @PathParam(value="name") String name, @Context UriInfo ui) {
        throw TrackerResource.buildException((int)405, (String)"The function is not available.");
    }

    public String getBuildStats(@PathParam(value="build_id") Long buildId, @PathParam(value="reportset") String reportset) {
        throw TrackerResource.buildException((int)405, (String)"The function is not available.");
    }
}

