/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.rest;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.rest.BaseReportRest;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.security.SecurityHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

@Path(value="/tracker")
public class TrackerBuildsResource
extends BaseReportRest {
    @Path(value="/builds/{configuration}")
    @GET
    public List<BuildFragment> getBuilds(@PathParam(value="configuration") String configuration, @QueryParam(value="count") int size) {
        Configuration c = this.getConfiguration(configuration);
        return BuildUtils.getLatestBuilds((Configuration)c, (int)size);
    }

    @Path(value="/builds/{configuration}/{ids}")
    @GET
    public List<BuildFragment> getBuilds(@PathParam(value="configuration") String configuration, @PathParam(value="ids") String ids, @QueryParam(value="count") int maxSize) {
        String[] tokens;
        if (Strings.isNullOrEmpty((String)ids)) {
            return Collections.emptyList();
        }
        this.getConfiguration(configuration);
        ArrayList buildIds = Lists.newArrayList();
        for (String each : tokens = ReportUtils.splitCsv((String)ids)) {
            buildIds.add(Long.valueOf(each));
        }
        return Lists.newArrayList((Iterable)BuildUtils.getBuilds((List)buildIds, (int)maxSize));
    }

    protected void checkPermission(Configuration c) {
        if (!SecurityHelper.hasPermission((Configuration)c, (String)"VIEW_ISSUES")) {
            throw new AccessDeniedException("You have no 'VIEW_ISSUE' permission to access configuration " + c.getPathName());
        }
    }

    protected ReportCategory getCategory() {
        return null;
    }
}

