/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.renderer.toolbar;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.plugin.tracker.core.AbstractIssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.renderer.toolbar.AbstractLinkIssuePanel;
import com.pmease.quickbuild.plugin.tracker.core.renderer.toolbar.AbstractLinkIssueToolbar;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public abstract class CustomIssueListPanel
extends AbstractLinkIssuePanel {
    private static final long serialVersionUID = 1L;
    private String list;
    private final Form<Void> form;
    private List<Issue> issues = new ArrayList<Issue>();

    protected abstract AbstractIssueTracker getTracker();

    public CustomIssueListPanel(String id, AbstractLinkIssueToolbar toolbar) {
        super(id, toolbar);
        this.form = new Form("linkIssuesForm");
        this.form.setOutputMarkupId(true);
        this.add(new Component[]{this.form});
        FeedbackPanel feedback = new FeedbackPanel("feedback", (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(this.form));
        feedback.setEscapeModelStrings(false);
        this.form.add(new Component[]{feedback});
        TextArea textarea = new TextArea("list", (IModel)new PropertyModel((Object)this, "list"));
        this.form.add(new Component[]{textarea});
        AjaxButton submitBtn = new AjaxButton("submit", this.form){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                boolean succeed = CustomIssueListPanel.this.updateIssues();
                if (!succeed) {
                    target.add(new Component[]{form});
                } else {
                    CustomIssueListPanel.this.onAfterSubmit(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        };
        this.form.add(new Component[]{this.createIssueListLabel("issueListLabel")});
        this.form.add(new Component[]{submitBtn});
        this.form.setDefaultButton((IFormSubmittingComponent)submitBtn);
        this.form.add(new Component[]{new AjaxLink<Void>("cancelButton"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                CustomIssueListPanel.this.onAfterCancel(target);
            }
        }});
    }

    protected Component createIssueListLabel(String id) {
        return new WebMarkupContainer("issueListLabel");
    }

    private boolean updateIssues() {
        if (StringUtils.isEmpty((String)this.list)) {
            this.issues = Collections.emptyList();
            return true;
        }
        Iterable keys = Splitter.on((char)' ').trimResults().split((CharSequence)this.list);
        AbstractIssueTracker tracker = this.getTracker();
        try {
            Map<String, Issue> issues = tracker.fetchIssues(Lists.newArrayList((Iterable)keys));
            this.issues = new ArrayList<Issue>(issues.values());
            return true;
        }
        catch (TrackerException e) {
            this.form.error((Serializable)((Object)e.getMessage()));
            return false;
        }
    }

    @Override
    protected List<Issue> getIssues() {
        return this.issues;
    }
}

