/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.renderer.toolbar;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.MergeFunction;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.duplicate.AlwaysCurrent;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.IssueCategory;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.web.behavior.ConfirmBehavior;
import com.pmease.quickbuild.web.component.dialog.Dialog;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.link.DownloadLink;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public abstract class AbstractLinkIssueToolbar
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;
    final DataGrid dataGrid;

    protected abstract Component createLinkIssuePanel(String var1);

    protected abstract Class<? extends AbstractTrackerPlugin> getPluginClass();

    public AbstractLinkIssueToolbar(DataGrid table, String extraCss) {
        super((DataTable)table);
        this.dataGrid = table;
        this.setOutputMarkupId(true);
        WebMarkupContainer container = new WebMarkupContainer("span");
        this.add(new Component[]{container});
        container.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)extraCss)), " ")});
        container.add(new Behavior[]{new AttributeModifier("colspan", (IModel)Model.of((Serializable)Integer.valueOf(table.getColumns().size())))});
        container.add(new Component[]{new DownloadLink("exportLink", this.getExportFileModel()).setDeleteAfterDownload(true)});
        container.add(new Component[]{new AjaxLink<Void>("addIssuesLink"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                new Dialog("Link Issues to this build"){
                    private static final long serialVersionUID = 1L;

                    protected Component render(String id) {
                        return AbstractLinkIssueToolbar.this.createLinkIssuePanel(id);
                    }
                }.dialogClass("popup-editor").width(600).resizable(false).open(target);
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setEnabled(!ChangesHelper.hasComparingBuild());
            }
        }});
        AjaxLink<Void> removeLink = new AjaxLink<Void>("removeLink"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                AbstractLinkIssueToolbar.this.removeIssues();
                target.add(new Component[]{AbstractLinkIssueToolbar.this.dataGrid});
            }

            protected void onConfigure() {
                super.onConfigure();
                this.setEnabled(!ChangesHelper.hasComparingBuild());
            }
        };
        removeLink.add(new Behavior[]{new ConfirmBehavior((IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                StringBuffer sb = new StringBuffer();
                int size = AbstractLinkIssueToolbar.this.dataGrid.getProvider().size();
                sb.append("<p><strong>Are you sure you want to permanently remove the issues from this build?</strong></p>");
                sb.append("<p>Total <strong>").append(size).append("</strong> issues</p>");
                return sb.toString();
            }
        })});
        container.add(new Component[]{removeLink});
    }

    protected void onConfigure() {
        super.onConfigure();
        this.setVisible(SecurityHelper.hasPermission((String)"LINK_ISSUES") && this.dataGrid.getRenderer().getMode() == RendererMode.BUILD);
    }

    public int addIssues(Collection<Issue> issues) {
        if (issues == null || issues.isEmpty()) {
            return 0;
        }
        Build build = Context.getBuild();
        IssueCategory category = (IssueCategory)ReportHelper.getCategory(this.getPluginClass());
        File dbDir = category.getReportDirOfBuild(build, "DEFAULT");
        DataReport report = category.createReport("issues");
        for (Issue issue : issues) {
            DataRow row = report.addRow();
            row.fromBean((Object)issue, true);
            row.setValue("buildId", (Object)build.getId());
        }
        category.saveReport(dbDir, report, (MergeFunction)new AlwaysCurrent());
        dbDir = category.getReportDirOfStats(build.getConfiguration(), "DEFAULT");
        category.saveReport(dbDir, report, (MergeFunction)new AlwaysCurrent());
        return issues.size();
    }

    protected Set<String> getIssueKeysInDataGrid() {
        DataReport report = this.dataGrid.getReportPanel().getDefaultReport();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (DataRow each : report.getRows()) {
            keys.add(each.getString("issueKey"));
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIssues() {
        Set<String> keys = this.getIssueKeysInDataGrid();
        Build build = Context.getBuild();
        Long buildId = build.getId();
        IssueCategory category = (IssueCategory)ReportHelper.getCategory(this.getPluginClass());
        File buildDir = category.getReportDirOfBuild(build, "DEFAULT");
        File statsDir = category.getReportDirOfStats(build.getConfiguration(), "DEFAULT");
        CategoryDb buildDb = category.getCategoryDb(buildDir);
        CategoryDb statsDb = category.getCategoryDb(statsDir);
        try {
            buildDb.open(DbStore.Mode.READ_WRITE, "AbstractLinkIssueToolbar::removeIssues");
            statsDb.open(DbStore.Mode.READ_WRITE, "AbstractLinkIssueToolbar::removeIssues");
            for (String key : keys) {
                SqlBuilder query = SqlBuilder.deleteFrom((String)"issues").where(new Filter[]{Restrictions.eq((String)"issueKey", (Object)key), Restrictions.eq((String)"buildId", (Object)buildId)});
                buildDb.update(query);
                statsDb.update(query);
            }
        }
        finally {
            buildDb.close();
            statsDb.close();
        }
    }

    public DataGrid getDataGrid() {
        return this.dataGrid;
    }

    public IModel<File> getExportFileModel() {
        return new LoadableDetachableModel<File>(){
            private static final long serialVersionUID = 1L;

            protected File load() {
                TableReportPanel panel = AbstractLinkIssueToolbar.this.getDataGrid().getReportPanel();
                File tmpFile = FileUtils.createTempFile((String)"issue-", (String)".xml");
                DataReport report = panel.getDefaultReport();
                if (report != null) {
                    report.saveToXML(tmpFile);
                }
                return tmpFile;
            }
        };
    }
}

