/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.renderer;

import com.google.common.base.Strings;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.TextItem;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public class IssueTextItem
extends TextItem {
    private static final long serialVersionUID = 1L;

    public IssueTextItem(AbstractRenderer renderer) {
        super(renderer);
    }

    public Component createComponent(String id, IModel<ItemContext> model) {
        ItemContext context = (ItemContext)model.getObject();
        String text = super.getText(context);
        String issueUrl = (String)context.get("ISSUE_URL");
        DataRow row = context.getDataRow();
        String issueKey = row.getValueAsString("issueKey");
        String href = "#";
        if (!Strings.isNullOrEmpty((String)issueUrl)) {
            href = issueUrl.replace("$KEY", issueKey);
        }
        String status = row.getValueAsString("status");
        String css = this.getCss();
        if (css == null) {
            css = "";
        }
        text = new StringBuffer().append("<a href='").append(href).append("' target='_blank' class='issue-link issue-status ").append(status.toLowerCase()).append(" " + css).append("'>").append(text).append("</a>").toString();
        return new Label(id, text).setEscapeModelStrings(false);
    }
}

