/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.renderer;

import com.google.common.collect.Maps;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.summary.ReportSummaryPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.summary.ReportSummaryRenderer;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public abstract class IssueSummaryRenderer
extends ReportSummaryRenderer {
    private static final long serialVersionUID = 1L;

    public abstract String getTitle();

    public IssueSummaryRenderer(ReportCategory category) {
        super(category);
        this.onInitialize();
    }

    protected void onInitialize() {
        this.initFromClassResource(IssueSummaryRenderer.class);
    }

    public Panel render(String id, IModel<RendererContext> model) {
        return this.createReportPanel(id, model);
    }

    public Panel createReportPanel(String id, IModel<RendererContext> model) {
        return new ReportSummaryPanel(id, this, model){
            private static final long serialVersionUID = 1L;

            protected Map<String, Object> getReportStats(Build build, String reportset) {
                ReportCategory category = IssueSummaryRenderer.this.getCategory();
                File dbDir = category.getReportDirOfBuild(build, reportset);
                HashMap map = Maps.newHashMap();
                map.put("TOTALS", category.getRowsCount(dbDir, "issues"));
                return map;
            }
        };
    }
}

