/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.renderer;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.renderer.ChangesReportPanel;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.Order;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.RendererItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.GridColumn;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.IssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.renderer.DeleteIssueItem;
import com.pmease.quickbuild.plugin.tracker.core.renderer.IssueDataGrid;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.SecurityHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.model.IModel;

public abstract class IssueReportPanel
extends ChangesReportPanel {
    private static final long serialVersionUID = 1L;
    public static final String ISSUE_CONTEXT_KEY = IssueReportPanel.class.getName() + ".ISSUE";

    protected IssueTracker getTracker() {
        Plugin plugin = PluginManager.instance.getDeclaringPlugin(this.getRenderer().getCategory().getClass());
        if (plugin instanceof AbstractTrackerPlugin) {
            return ((AbstractTrackerPlugin)plugin).createTracker();
        }
        throw new QuickbuildException("Please override getTracker() method if you didn't inherit from AbstractTrackerPlugin.");
    }

    protected abstract boolean isConnectionFailed();

    public IssueReportPanel(String id, TableRenderer renderer, IModel<RendererContext> model) {
        super(id, renderer, model);
    }

    protected List<IColumn<ItemContext>> getColumns() {
        ArrayList columns = Lists.newArrayList((Iterable)super.getColumns());
        IColumn<ItemContext> opColumn = this.createOpColumn();
        if (opColumn != null) {
            columns.add(opColumn);
        }
        return columns;
    }

    public String getDefaultScript() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.getDefaultScript());
        sb.append("$('#$gridId tr').hoverIntent({over: function() { $(this).addClass('tr-on-focus'); }, \t\t\t\t\t\t\t out: function() { $(this).removeClass('tr-on-focus'); },\t\t\t\t\t\t\t sensitivity: 1, interval: 10 });");
        return sb.toString();
    }

    protected IColumn<ItemContext> createOpColumn() {
        if (SecurityHelper.hasPermission((String)"LINK_ISSUES")) {
            TableColumn opColumn = new TableColumn((AbstractRenderer)this.getRenderer());
            opColumn.addItem((RendererItem)new DeleteIssueItem((AbstractRenderer)this.getRenderer()));
            opColumn.setCss("issue-action");
            return new GridColumn(opColumn);
        }
        return null;
    }

    protected DataGrid newDataGrid(String id) {
        return new IssueDataGrid(id, this.getColumns(), this.provider, (TableReportPanel)this);
    }

    public Iterator<ItemContext> iterator(int first, int count) {
        DataReport report;
        long start = System.currentTimeMillis();
        if (!this.isShowReports()) {
            return Iterators.emptyIterator();
        }
        DataReport passthrough = this.getContext().getPassthroughReport();
        ArrayList orders = Lists.newArrayList();
        if (ChangesHelper.hasComparingBuild()) {
            orders.add(new Order("buildId", false));
        }
        orders.addAll(this.provider.getOrders());
        if (passthrough != null) {
            if (!orders.isEmpty()) {
                passthrough.sortRows((List)orders);
            }
            int toIndex = Math.min(first + count, passthrough.getRowsCount());
            ArrayList rows = Lists.newArrayList(passthrough.getRows().subList(first, toIndex));
            report = passthrough.newInstance(false);
            report.setRows((List)rows);
        } else {
            SqlBuilder query = this.createQuery();
            query.limit(count);
            query.offset(first);
            if (!orders.isEmpty()) {
                query.clearOrderBy();
                query.orderby((List)orders);
            }
            report = this.loadReport(query);
        }
        if (Context.getLogger().isDebugEnabled()) {
            Context.getLogger().debug("Load data rows cost: " + (System.currentTimeMillis() - start) + " millis.");
        }
        List<ItemContext> list = this.createContexts(report);
        return list.iterator();
    }

    private List<ItemContext> createContexts(DataReport report) {
        List rows = report.getRows();
        ArrayList<String> ids = new ArrayList<String>();
        for (DataRow row : rows) {
            ids.add(row.getValueAsString("issueKey"));
        }
        ArrayList list = Lists.newArrayList();
        try {
            Map<String, Issue> issues = this.fetchIssues(ids);
            Iterator it = rows.iterator();
            while (it.hasNext()) {
                DataRow row = (DataRow)it.next();
                String id = row.getValueAsString("issueKey");
                Issue issue = issues.get(id);
                if (issue == null) {
                    it.remove();
                    continue;
                }
                row.fromBean((Object)issue, true);
                ItemContext c = this.createItemContext(row);
                c.put(ISSUE_CONTEXT_KEY, (Object)issue);
                list.add(c);
            }
        }
        catch (TrackerException e) {
            Context.getLogger().error("Update issues failed from server!", (Throwable)e);
            this.onUpdateIssuesFailed(e.getMessage());
        }
        return list;
    }

    public ItemContext createItemContext(DataRow row) {
        ItemContext context = super.createItemContext(row);
        context.put("ISSUE_URL", (Object)this.getTracker().getIssueUrlPattern());
        return context;
    }

    protected Map<String, Issue> fetchIssues(List<String> ids) {
        if (this.isConnectionFailed()) {
            return Collections.emptyMap();
        }
        IssueTracker tracker = this.getTracker();
        return tracker.fetchIssues(ids);
    }

    protected void onUpdateIssuesFailed(String msg) {
        this.dataGrid.error((Serializable)((Object)("Update issues failed from server! " + msg)));
    }
}

