/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.renderer;

import com.google.common.base.Strings;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.changes.extensionpoint.ChangeFormatterSupport;
import com.pmease.quickbuild.plugin.report.changes.rest.RawChangeset;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.util.MapHelper;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import com.pmease.quickbuild.plugin.tracker.core.renderer.IssueModificationDropDownItem;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import com.pmease.quickbuild.repositorysupport.Modification;
import com.pmease.quickbuild.repositorysupport.Repository;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;

public class IssueModificationPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    final IModel<Map<String, Repository<?>>> repositoriesModel;
    final IssueModificationDropDownItem item;

    public IssueModificationPanel(String id, IssueModificationDropDownItem item, final IModel<ItemContext> model) {
        super(id, model);
        this.item = item;
        this.repositoriesModel = new LoadableDetachableModel<Map<String, Repository<?>>>(){
            private static final long serialVersionUID = 1L;

            protected Map<String, Repository<?>> load() {
                ItemContext ic = (ItemContext)model.getObject();
                Configuration configuration = ic.getConfiguration();
                return configuration.findRepositories();
            }
        };
        this.add(new Component[]{new ListView<RawChangeset>("changesets", (IModel)new LoadableDetachableModel<List<RawChangeset>>(){
            private static final long serialVersionUID = 1L;

            protected List<RawChangeset> load() {
                return IssueModificationPanel.this.getChanges();
            }
        }){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<RawChangeset> item) {
                RawChangeset commit = (RawChangeset)item.getModelObject();
                item.add(new Component[]{new Label("comment", commit.getComment()).setEscapeModelStrings(true)});
                String user = commit.getUser();
                if (Strings.isNullOrEmpty((String)user)) {
                    user = "anonymous";
                }
                item.add(new Component[]{new Label("committer", user)});
                item.add(new Component[]{new Label("commitDate", DataTypes.DATE.asString((Object)commit.getDate(), "age"))});
                item.add(new Component[]{new Label("repository", commit.getRepositoryName())});
                Map<String, Repository<?>> repositories = IssueModificationPanel.this.getRepositories();
                Repository<?> repository = repositories.get(commit.getRepositoryName());
                String id = commit.getId();
                if (repository != null && repository instanceof ChangeFormatterSupport) {
                    id = ((ChangeFormatterSupport)repository).format("CHANGEID", IssueModificationPanel.commitToMap(commit));
                }
                item.add(new Component[]{new Label("changeId", id)});
                List modifications = commit.getModifications();
                item.add(new Component[]{new Label("totals", String.valueOf(modifications.size()))});
                item.add(new Component[]{new ModificationListView("modifications", commit.getBuildId(), commit.getRepositoryName(), commit.getModifications()).setVisible(modifications.size() > 0)});
            }
        }});
    }

    static Map<String, Object> commitToMap(RawChangeset commit) {
        Map map = MapHelper.beanToMap((Object)commit);
        map.put("changeId", commit.getId());
        return map;
    }

    Map<String, Repository<?>> getRepositories() {
        return (Map)this.repositoriesModel.getObject();
    }

    private List<RawChangeset> getChanges() {
        ItemContext context = (ItemContext)this.getDefaultModelObject();
        DataRow row = context.getDataRow();
        return TrackerHelper.getIssueChanges(this.item.getCategory(), Context.getConfiguration(), row.getString("issueKey"), row.getLong("buildId"), row.getLong("buildId"), 0, 0, false);
    }

    public void onDetach() {
        this.repositoriesModel.detach();
        super.onDetach();
    }

    class ModificationListView
    extends ListView<Modification> {
        private static final long serialVersionUID = 1L;
        final Long buildId;
        final String repositoryName;

        public ModificationListView(String id, Long buildId, String repositoryName, List<? extends Modification> list) {
            super(id, list);
            this.buildId = buildId;
            this.repositoryName = repositoryName;
        }

        protected void populateItem(ListItem<Modification> item) {
            Modification modification = (Modification)item.getModelObject();
            Label c = new Label("action", modification.getAction().name());
            c.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)modification.getAction().name().toLowerCase())), " ")});
            item.add(new Component[]{c});
            item.add(new Component[]{new Label("fileName", modification.getPath())});
            item.add(new Component[]{new Label("view", this.formatViewLink(modification)).setEscapeModelStrings(false)});
            item.add(new Component[]{new Label("diff", this.formatDiffLink(modification)).setEscapeModelStrings(false)});
        }

        String formatViewLink(Modification modification) {
            if (!ChangesHelper.canViewSource((Modification)modification)) {
                return "<span class='disabled-link'>View</span>";
            }
            Map<String, Repository<?>> repositories = IssueModificationPanel.this.getRepositories();
            if (!repositories.containsKey(this.repositoryName)) {
                return "<span class='disabled-link'>View</span>";
            }
            if (!ReportUtils.isValidBuild((Long)this.buildId)) {
                return "<span class='disabled-link'>View</span>";
            }
            return "<a target='_blank' href='" + ChangesHelper.getViewSourceUrl((Long)this.buildId, (String)this.repositoryName, (Modification)modification) + "'>View</a>";
        }

        String formatDiffLink(Modification modification) {
            if (!ChangesHelper.canDiffSource((Modification)modification)) {
                return "<span class='disabled-link'>Diff</span>";
            }
            Map<String, Repository<?>> repositories = IssueModificationPanel.this.getRepositories();
            if (!repositories.containsKey(this.repositoryName)) {
                return "<span class='disabled-link'>Diff</span>";
            }
            if (!ReportUtils.isValidBuild((Long)this.buildId)) {
                return "<span class='disabled-link'>Diff</span>";
            }
            return "<a target='_blank' href='" + ChangesHelper.getDiffSourceUrl((Long)this.buildId, (String)this.repositoryName, (Modification)modification) + "'>Diff</a>";
        }
    }
}

