/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.renderer;

import com.google.common.base.Objects;
import com.pmease.quickbuild.plugin.report.changes.ChangesHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableReportPanel;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.GroupableDataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.provider.ReportDataProvider;
import com.pmease.quickbuild.plugin.report.engine.util.BuildFragment;
import com.pmease.quickbuild.plugin.report.engine.util.BuildUtils;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class IssueDataGrid
extends GroupableDataGrid {
    private static final long serialVersionUID = 1L;

    public IssueDataGrid(String id, List<IColumn<ItemContext>> columns, ReportDataProvider dataProvider, TableReportPanel parentPanel) {
        super(id, columns, dataProvider, parentPanel);
    }

    protected Item<ItemContext> newRowItem(String id, int index, IModel<ItemContext> rowModel) {
        Item item = super.newRowItem(id, index, rowModel);
        ItemContext context = (ItemContext)rowModel.getObject();
        DataRow row = context.getDataRow();
        String status = row.getValueAsString("status");
        item.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)("issue-status " + status.toLowerCase()))), " ")});
        return item;
    }

    protected boolean isGroupable() {
        if (this.getReportPanel().getRenderer().getMode() == RendererMode.STATISTICS) {
            return true;
        }
        return ChangesHelper.hasComparingBuild();
    }

    protected boolean isGroupRow(DataRow current) {
        Long previousBuildId;
        if (this.previous == null) {
            return true;
        }
        Long currentBuildId = current.getLong("buildId");
        return !Objects.equal((Object)currentBuildId, (Object)(previousBuildId = Long.valueOf(this.previous.getLong("buildId"))));
    }

    protected String getGroupRowHtml(DataRow row) {
        StringBuffer sb = new StringBuffer();
        sb.append("<tr class='group-row'><td colspan='").append(this.getColumns().size()).append("'>");
        sb.append("<h2>");
        Long buildId = row.getLong("buildId");
        BuildFragment b = BuildUtils.getBuildFragment((Long)buildId);
        sb.append(BuildUtils.hyperlinkBuild((BuildFragment)b));
        if (b != null) {
            sb.append(" <span class='light-text'>(").append(DataTypes.DATE.asString((Object)b.getBeginDate(), "EEEEE, MMMMM dd")).append(")</span>");
        }
        sb.append("</h2></td></tr>");
        return sb.toString();
    }
}

