/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.renderer;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.RendererItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.TextItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import java.io.File;
import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public abstract class FailedCommandsRenderer
extends TableRenderer {
    private static final long serialVersionUID = 1L;

    protected abstract String getIssueKeyLink(String var1);

    public FailedCommandsRenderer(ReportCategory category) {
        super(category);
        this.onInitialize();
    }

    protected void onInitialize() {
        this.initFromClassResource(FailedCommandsRenderer.class);
        ArrayList columns = Lists.newArrayList();
        columns.add(this.createIssueKeyColumn());
        columns.addAll(this.getColumns());
        this.setColumns(columns);
    }

    protected TableColumn createIssueKeyColumn() {
        TableColumn column = new TableColumn((AbstractRenderer)this);
        column.setCss("nowrap-text");
        column.setTitle("Issue");
        column.setOrderBy("issueKey");
        TextItem item = new TextItem((AbstractRenderer)this){
            private static final long serialVersionUID = 1L;

            public Component createComponent(String id, IModel<ItemContext> model) {
                ItemContext context = (ItemContext)model.getObject();
                String issueKey = this.getText(context);
                String link = FailedCommandsRenderer.this.getIssueKeyLink(issueKey);
                return new Label(id, link).setEscapeModelStrings(false);
            }
        };
        item.setValueExpression("issueKey");
        column.addItem((RendererItem)item);
        return column;
    }

    public boolean isApplicable() {
        Build build = Context.getBuild();
        if (build == null) {
            return false;
        }
        File dbDir = this.category.getReportDirOfBuild(build, "DEFAULT");
        long count = this.category.getRowsCount(dbDir, "failedcommands");
        return count > 0L;
    }
}

