/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.renderer;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.item.RendererItem;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.report.engine.web.ImageLinkPanel;
import com.pmease.quickbuild.plugin.report.engine.web.jquery.JQConfirmLink;
import java.io.File;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class DeleteIssueItem
extends RendererItem {
    private static final long serialVersionUID = 1L;

    public DeleteIssueItem(AbstractRenderer renderer) {
        super(renderer);
    }

    public String getType() {
        return DeleteIssueItem.class.getName();
    }

    public Component createComponent(String id, final IModel<ItemContext> model) {
        return new ImageLinkPanel(id, (IModel)Model.of((Serializable)((Object)"/images/button/trash.png"))){
            private static final long serialVersionUID = 1L;

            protected AbstractLink createLink(String id) {
                return DeleteIssueItem.this.createDeleteLink(id, (IModel<ItemContext>)model);
            }
        };
    }

    protected AbstractLink createDeleteLink(String id, final IModel<ItemContext> model) {
        ItemContext context = (ItemContext)model.getObject();
        String issueKey = context.getDataRow().getString("issueKey");
        JQConfirmLink<Void> link = new JQConfirmLink<Void>(id, "Are you sure you want to remove issue [ <strong>" + issueKey + "</strong> ] from the list?"){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClick(AjaxRequestTarget target) {
                ItemContext context = (ItemContext)model.getObject();
                DataRow row = context.getDataRow();
                DataGrid dataGrid = context.getDataGrid();
                SqlBuilder query = SqlBuilder.deleteFrom((String)"issues").where(new Filter[]{Restrictions.eq((String)"buildId", (Object)row.getLong("buildId")), Restrictions.eq((String)"issueKey", (Object)row.getString("issueKey"))});
                if (DeleteIssueItem.this.getRenderer().getMode() == RendererMode.BUILD) {
                    Long buildId = row.getLong("buildId");
                    BuildManager buildManager = (BuildManager)Quickbuild.getInstance(BuildManager.class);
                    Build build = (Build)buildManager.get(buildId);
                    if (build != null) {
                        File dbDir = DeleteIssueItem.this.category.getReportDirOfBuild(build, "DEFAULT");
                        CategoryDb db = DeleteIssueItem.this.category.getCategoryDb(dbDir);
                        try {
                            db.open(DbStore.Mode.READ_WRITE, "DeleteIssueItem::buildDb");
                            db.update(query);
                        }
                        finally {
                            db.close();
                        }
                    }
                }
                File dbDir = DeleteIssueItem.this.category.getReportDirOfStats(context.getConfiguration(), "DEFAULT");
                CategoryDb db = DeleteIssueItem.this.category.getCategoryDb(dbDir);
                try {
                    db.open(DbStore.Mode.READ_WRITE, "DeleteIssueItem::statsDb");
                    db.update(query);
                }
                finally {
                    db.close();
                }
                dataGrid.info((Serializable)((Object)("Issue " + row.getValueAsString("issueKey") + " is removed successfully.")));
                target.add(new Component[]{dataGrid});
            }
        };
        return link;
    }
}

