/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.migration;

import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.ReportCategoryMigrator;
import com.pmease.quickbuild.plugin.tracker.core.IssueCategory;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;

public class IssueCategoryMigrator
extends ReportCategoryMigrator {
    private void migrateBuildReport1(IssueCategory category, Build build, File categoryDir) {
        File statsDir = category.getReportDirOfStats(build.getConfiguration(), "DEFAULT");
        if (!statsDir.exists()) {
            return;
        }
        File dbDir = new File(categoryDir, "DEFAULT");
        try {
            DataReport report = category.loadReport(statsDir, "issues", new Filter[]{Restrictions.eq((String)"buildId", (Object)build.getId())});
            category.saveReport(dbDir, report);
        }
        catch (Exception e) {
            if (categoryDir.exists()) {
                Collection files = FileUtils.listFiles((File)categoryDir, (String)"**/*.h2.db");
                for (File each : files) {
                    FileUtils.deleteFile((File)each);
                }
            }
            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateStatsReport1(IssueCategory category, File categoryDir) {
        File dbDir = new File(categoryDir, "DEFAULT");
        File buildsDir = new File(categoryDir, "builds");
        if (!buildsDir.exists()) {
            return;
        }
        Collection files = FileUtils.listFiles((File)buildsDir, (String)"**/issues.xml");
        HashSet<Long> buildIds = new HashSet<Long>();
        CategoryDb db = category.getCategoryDb(dbDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "IssueCategoryMigrator::migrateStatsReport1");
            for (File each : files) {
                File f = each.getParentFile();
                Long id = (Long)DataTypes.LONG.fromString(f.getName(), null);
                if (id == null) continue;
                if (buildIds.contains(id)) {
                    db.update("DELETE FROM issues WHERE buildId = " + id);
                }
                DataReport report = category.createReport("issues");
                report.loadFromXML(each);
                for (DataRow row : report.getRows()) {
                    row.setValue("buildId", (Object)id);
                }
                category.saveReport(db, report);
                buildIds.add(id);
            }
        }
        finally {
            db.close();
        }
    }

    private void migrate1(MigrationContext context, Stack<Integer> versions) {
        IssueCategory category = (IssueCategory)context.getCategory();
        Build build = context.getBuild();
        if (build != null) {
            this.migrateBuildReport1(category, build, context.getDir());
        } else {
            try {
                this.migrateStatsReport1(category, context.getDir());
            }
            catch (Exception e) {
                if (context.getDir().exists()) {
                    Collection files = FileUtils.listFiles((File)context.getDir(), (String)"**/*.h2.db");
                    for (File each : files) {
                        FileUtils.deleteFile((File)each);
                    }
                }
                throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
            }
        }
    }
}

