/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.gadget;

import com.pmease.quickbuild.plugin.report.engine.datastore.ReportDataSource;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererContext;
import com.pmease.quickbuild.plugin.report.engine.renderer.RendererMode;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.ReportGadgetWithTable;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.datagrid.DataGrid;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.toolbar.SearchNavToolbar;
import com.pmease.quickbuild.plugin.tracker.core.IssueCategory;
import com.pmease.quickbuild.plugin.tracker.core.renderer.SimpleIssueRenderer;
import com.pmease.quickbuild.plugin.tracker.core.renderer.SimpleIssueReportPanel;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackHeadersToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class SimpleIssueGadgetRenderer
extends SimpleIssueRenderer {
    private static final long serialVersionUID = 1L;
    private final ReportGadgetWithTable gadget;

    public SimpleIssueGadgetRenderer(IssueCategory category, ReportGadgetWithTable gadget) {
        super(category);
        this.setMode(RendererMode.BUILD);
        ReportDataSource rds = this.getDataSource();
        rds.setOrderBy("buildId, created");
        rds.setAsc("false, false");
        this.setContentOnly(true);
        this.setCss("gadget-table");
        this.gadget = gadget;
    }

    @Override
    public Panel createReportPanel(String id, IModel<RendererContext> model) {
        return new SimpleIssueReportPanel(id, this, model){
            private static final long serialVersionUID = 1L;

            @Override
            protected IColumn<ItemContext> createOpColumn() {
                return null;
            }

            @Override
            protected void addToolbars(DataGrid dataGrid) {
                super.addDefaultToolbars(dataGrid);
                dataGrid.addTopToolbar((AbstractToolbar)new AjaxFallbackHeadersToolbar((DataTable)dataGrid, (ISortStateLocator)dataGrid.getProvider()));
                dataGrid.addBottomToolbar((AbstractToolbar)new SearchNavToolbar.NavBar(dataGrid, Integer.valueOf(SimpleIssueGadgetRenderer.this.gadget.getRowsPerPage()).intValue()));
            }
        };
    }
}

