/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.gadget;

import com.google.common.collect.Lists;
import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.renderer.gadget.ReportGadgetWithTable;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.TableRenderer;
import com.pmease.quickbuild.plugin.report.engine.renderer.table.column.TableColumn;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.IssueCategory;
import com.pmease.quickbuild.plugin.tracker.core.gadget.SimpleIssueGadgetRenderer;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.SecurityHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.Size;

public abstract class AbstractIssueGadget
extends ReportGadgetWithTable {
    private static final long serialVersionUID = 1L;
    private List<String> selectedColumns = Lists.newArrayList();

    protected void checkPermission() {
        Configuration c = Context.getConfiguration();
        if (c == null) {
            throw new QuickbuildException("Configuration not set correctly in Context while rendering Jira gadget.");
        }
        if (!SecurityHelper.hasPermission((String)"VIEW_ISSUES")) {
            throw new AccessDeniedException("You have no permission to access issues for the configuration: " + c.getPathName());
        }
    }

    protected ReportCategory getCategory() {
        Plugin plugin = PluginManager.instance.getDeclaringPlugin(((Object)((Object)this)).getClass());
        if (plugin instanceof AbstractTrackerPlugin) {
            return ((AbstractTrackerPlugin)plugin).getReportCategory();
        }
        throw new QuickbuildException("Invalid tracker plugin class, please override getCategory().");
    }

    protected TableRenderer createGadgetRenderer() {
        return new SimpleIssueGadgetRenderer((IssueCategory)this.getCategory(), this);
    }

    protected TableRenderer createTableRenderer() {
        TableRenderer r = this.createGadgetRenderer();
        ArrayList columns = Lists.newArrayList();
        List<String> selected = this.getSelectedColumns();
        block0: for (String each : selected) {
            for (TableColumn column : r.getColumns()) {
                if (!column.getKey().equalsIgnoreCase(each)) continue;
                column.setOrderBy(null);
                columns.add(column);
                continue block0;
            }
        }
        r.setColumns((Collection)columns);
        return r;
    }

    protected String getToTab() {
        return "Related Issues";
    }

    @Editable(name="Columns to display", description="Select columns you want to display", order=500)
    @ChoiceProvider(value="getAvailableColumns")
    @Size(min=1)
    public List<String> getSelectedColumns() {
        return this.selectedColumns;
    }

    public void setSelectedColumns(List<String> selectedColumns) {
        this.selectedColumns = selectedColumns;
    }

    public List<String> getReportsets() {
        return Lists.newArrayList((Object[])new String[]{"DEFAULT"});
    }

    private static List<String> getAvailableColumns() {
        return Lists.newArrayList((Object[])new String[]{"Key", "Summary", "Type", "Status", "Priority", "Resolution", "Assignee", "Modifications"});
    }
}

