/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.extensionpoint;

import com.google.common.base.Objects;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datatype.DataTypes;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

@XStreamAlias(value="issue")
@ScriptApi(value="A generic representation of bug/issue")
public class Issue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long buildId;
    private String issueKey;
    private String issueType;
    private String summary;
    private String status;
    private String priority;
    private String resolution;
    private Calendar created;
    private Calendar updated;
    private String assignee;
    private String reporter;
    private boolean existed = true;

    public static boolean isSameIssue(DataRow row, Issue issue) {
        String key1 = row.getValueAsString("issueKey");
        String key2 = issue.getIssueKey();
        return ReportHelper.isEquals((Object)key1, (Object)key2);
    }

    @ScriptApi(value="Get the key of an issue")
    public String getIssueKey() {
        return this.issueKey;
    }

    public void setIssueKey(String issueKey) {
        this.issueKey = issueKey;
    }

    @ScriptApi(value="Get the type of an issue")
    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = issueType;
    }

    @ScriptApi(value="Get the summary of an issue")
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    @ScriptApi(value="Get the status of an issue")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @ScriptApi(value="Get the priority of an issue")
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    @ScriptApi(value="Get the resolution of an issue")
    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    @ScriptApi(value="Get the created date of an issue")
    public Calendar getCreated() {
        return this.created;
    }

    public void setCreated(Calendar created) {
        this.created = created;
    }

    public void setCreated(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.created = cal;
    }

    @ScriptApi(value="Get the last updated date of an issue")
    public Calendar getUpdated() {
        return this.updated;
    }

    public void setUpdated(Calendar updated) {
        this.updated = updated;
    }

    public void setUpdated(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.updated = cal;
    }

    @ScriptApi(value="Get the assignee of an issue")
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    @ScriptApi(value="Get the reporter or creator of an issue")
    public String getReporter() {
        return this.reporter;
    }

    public void setReporter(String reporter) {
        this.reporter = reporter;
    }

    public boolean isExisted() {
        return this.existed;
    }

    public void setExisted(boolean existed) {
        this.existed = existed;
    }

    public Long getBuildId() {
        return this.buildId;
    }

    public void setBuildId(Long buildId) {
        this.buildId = buildId;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("key", (Object)this.issueKey).add("summary", (Object)this.summary).add("reporter", (Object)this.reporter).add("assignee", (Object)this.assignee).add("type", (Object)this.issueType).add("status", (Object)this.status).add("priority", (Object)this.priority).add("resolution", (Object)this.resolution).add("created", (Object)DataTypes.TIME.asString((Object)this.created, "yyyy-MM-dd HH:mm:ss")).add("updated", (Object)DataTypes.TIME.asString((Object)this.updated, "yyyy-MM-dd HH:mm:ss")).toString();
    }
}

