/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.contribution;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.extensionpoint.BuildListener;
import com.pmease.quickbuild.grid.GridJob;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommandParser;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.IssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import com.pmease.quickbuild.repositorysupport.BuildChangeset;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.LockUtils;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.regex.Pattern;

public abstract class IssuesBuildListener
implements BuildListener {
    protected abstract IssueTracker getTracker();

    protected abstract ReportCategory getCategory();

    public void buildStarted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished() {
        Build build = Context.getBuild();
        List changes = build.getChanges();
        IssueTracker tracker = this.getTracker();
        LinkedHashSet<String> issueKeys = new LinkedHashSet<String>();
        Pattern pIssue = tracker.getIssuePattern();
        ReportCategory category = this.getCategory();
        DataReport issueReport = category.createReport("issues");
        CaseInsensitiveMap rowIndexes = CaseInsensitiveMap.create();
        Map<String, String> issueActions = TrackerHelper.getIssueActions(category);
        for (BuildChangeset buildChangeset : changes) {
            String comment = buildChangeset.getComment();
            List<String> matched = CommandParser.getMatchedIssues(comment, pIssue);
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (String pattern : matched) {
                keys.add(tracker.extractIssueKey(pattern));
            }
            if (keys.isEmpty()) continue;
            for (String key : keys) {
                DataRow row;
                Integer index = (Integer)rowIndexes.get(key);
                if (index == null) {
                    row = issueReport.addRow();
                    row.setValue("issueKey", (Object)key);
                    row.setValue("buildId", (Object)build.getId());
                    rowIndexes.put(key, issueReport.getRowsCount() - 1);
                } else {
                    row = issueReport.getRow(index.intValue());
                }
                List changeIds = (List)row.getValue("changeIds");
                List repositories = (List)row.getValue("repositories");
                changeIds.add(buildChangeset.getId());
                repositories.add(buildChangeset.getRepositoryName());
                row.setValue("changeIds", (Object)changeIds);
                row.setValue("repositories", (Object)repositories);
                int modifications = row.getInt("modifications") + buildChangeset.getModifications().size();
                row.setValue("modifications", (Object)modifications);
                if (issueActions.containsKey(key)) {
                    row.setValue("action", (Object)issueActions.get(key));
                    issueActions.remove(key);
                }
                issueKeys.add(key);
            }
        }
        for (String string : issueActions.keySet()) {
            DataRow row = issueReport.addRow();
            row.setValue("buildId", (Object)build.getId());
            row.setValue("issueKey", (Object)string);
            row.setValue("action", (Object)issueActions.get(string));
            rowIndexes.put(string, issueReport.getRowsCount() - 1);
            issueKeys.add(string);
        }
        DataReport destReport = category.createReport("issues");
        try {
            Map<String, Issue> map = tracker.fetchIssues(issueKeys);
            for (String key : issueKeys) {
                Integer index = (Integer)rowIndexes.get(key);
                DataRow row = issueReport.getRow(index.intValue());
                Issue issue = map.get(key);
                if (issue == null) continue;
                row.fromBean((Object)issue, true);
                destReport.addRow(row.getValues());
            }
        }
        catch (TrackerException trackerException) {
            Context.getLogger().warn("Fetch issues from server failed! Use original data instead.", (Throwable)trackerException);
        }
        File file = new File(build.getPublishDir(), "reports/" + category.getId());
        Lock lock = LockUtils.lockForWrite((File)file);
        try {
            if (file.exists()) {
                if (Context.getLogger().isDebugEnabled()) {
                    Context.getLogger().info("Issues dir " + file + " exists, it may be left " + "from previous deleted build, delete it first.");
                }
                FileUtils.deleteDir((File)file);
            }
            FileUtils.createDir((File)file);
            category.writeVersionFile(file);
            File dbDir = category.getReportDirOfBuild(build, "DEFAULT");
            category.saveReport(dbDir, destReport);
            DataReport failedReport = TrackerHelper.getFailedReport(category);
            category.saveReport(dbDir, failedReport);
        }
        finally {
            lock.unlock();
        }
    }

    public void jobStarted(GridJob job) {
    }

    public void jobFinished(GridJob job) {
    }
}

