/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.contribution;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.plugin.report.engine.contribution.publisher.StatisticsReportPublisher;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.LastBuildsFile;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class IssueStatisticsProvider
extends StatisticsReportPublisher {
    public boolean isApplicable(Build build) {
        File buildDir;
        ReportCategory category = this.getCategory();
        return category.getRowsCount(buildDir = category.getReportDirOfBuild(build, "DEFAULT"), "issues") > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPublish(Build build) {
        ReportCategory category = this.getCategory();
        File buildDir = category.getReportDirOfBuild(build, "DEFAULT");
        category.createCategoryDirOfStats(build.getConfiguration());
        File statsDir = category.getReportDirOfStats(build.getConfiguration(), "DEFAULT");
        if (!statsDir.exists()) {
            FileUtils.createDir((File)statsDir);
        }
        DataReport issueReport = category.loadReport(buildDir, "issues", new Filter[0]);
        CategoryDb db = category.getCategoryDb(statsDir);
        try {
            db.open(DbStore.Mode.READ_WRITE, "IssueStatisticsProvider::doPublish");
            LastBuildsFile lbf = new LastBuildsFile(statsDir);
            lbf.load();
            List ids = lbf.getBuildIds();
            if (ids.size() > 0) {
                Collections.reverse(ids);
                Build previousFinished = build.getPreviousFinished();
                boolean hasRemoved = false;
                if (previousFinished != null) {
                    Long each;
                    Iterator it = ids.iterator();
                    while (it.hasNext() && (each = (Long)it.next()) > previousFinished.getId()) {
                        Context.getLogger().info("Delete issues of build : " + each + " which may be already deleted.");
                        it.remove();
                        hasRemoved = true;
                        db.update("DELETE FROM issues WHERE buildId=" + each);
                    }
                }
                if (hasRemoved) {
                    Collections.sort(ids);
                    lbf.setBuildIds(ids);
                    lbf.save();
                }
            }
            db.update("DELETE FROM issues where buildId = " + build.getId());
            category.saveReport(db, issueReport);
        }
        finally {
            db.close();
        }
    }
}

