/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.commitcomand;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import java.io.Serializable;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

public class CommitCommandDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String commandName;
    private String attributesText;

    public CommitCommandDef() {
    }

    public CommitCommandDef(String command, String attributesText) {
        this.commandName = command;
        this.attributesText = attributesText;
    }

    @Editable(order=200, name="Command Name", description="Define name the commit command which will be searched in SCM commit comments. <br/><strong>NOTE:</strong><br/>Commit command name is case-insensitive.")
    @Scriptable
    @ScriptApi(value="Get name of the commit command.")
    @NotEmpty
    public String getCommand() {
        return this.commandName;
    }

    public void setCommand(String command) {
        this.commandName = command;
    }

    @Editable(order=300, name="Preset Attributes", description="Specify preset attributes of issue/ticket when the command is processed.")
    @Scriptable
    public String getAttributesText() {
        return this.attributesText;
    }

    public void setAttributesText(String attributesText) {
        this.attributesText = attributesText;
    }

    public Map<String, String> getCommandOptions() {
        return StringHelper.getOptionsFromDefinition(this.getAttributesText());
    }
}

