/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.commitcomand;

import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.util.EqualsHelper;

public class CommitCommand {
    private Date date;
    private String action;
    private String issue;
    private String committer;
    private Map<String, String> options = CaseInsensitiveMap.create();

    public CommitCommand() {
    }

    public CommitCommand(String issue, String action) {
        this.issue = issue;
        this.action = action;
    }

    public CommitCommand(String issue, String action, Date date) {
        this.issue = issue;
        this.action = action;
        this.date = date;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getIssue() {
        return this.issue;
    }

    public void setIssue(String issue) {
        this.issue = issue;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getCommitter() {
        return this.committer;
    }

    public void setCommitter(String user) {
        this.committer = user;
    }

    public String getOptionValue(String option) {
        return this.options.get(option);
    }

    public boolean hasOption(String option) {
        return this.getOptionValue(option) != null;
    }

    public void addOption(String opt, String value) {
        this.options.put(opt, value);
    }

    public String getOptionsString() {
        StringBuffer sb = new StringBuffer();
        for (String opt : this.options.keySet()) {
            sb.append("--").append((Object)opt).append(" ");
            String v = this.options.get(opt);
            if (!StringUtils.isEmpty((String)v)) {
                v = StringUtils.replace((String)v, (String)"\"", (String)"\\\"");
                sb.append(v);
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getCommandLine() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.action.toLowerCase()).append(" ");
        if (!StringUtils.isEmpty((String)this.issue)) {
            sb.append(this.issue).append(" ");
        }
        sb.append(this.getOptionsString());
        return sb.toString();
    }

    public String toString() {
        return this.getCommandLine();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CommitCommand)) {
            return false;
        }
        CommitCommand rhs = (CommitCommand)obj;
        return EqualsHelper.equals((Object)this.toString(), (Object)rhs.toString());
    }

    public String dump() {
        StringBuffer sb = new StringBuffer();
        sb.append("Action: ").append(this.action).append("\n").append("Issue: ").append(this.issue).append("\n").append("Date: ").append(this.date).append("\n");
        sb.append("Params:\n");
        for (String opt : this.options.keySet()) {
            sb.append((Object)opt).append(": ").append(this.options.get(opt)).append("\n");
        }
        return sb.toString();
    }
}

