/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core.commitcomand;

import com.pmease.quickbuild.plugin.report.engine.util.CaseInsensitiveMap;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommitCommand;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class CommandParser {
    public static final Pattern pParam = Pattern.compile("(?<=^|\\s)(--|-)\\w+");
    static Pattern pSplitter = Pattern.compile("(,|and)", 2);

    public static List<String> getMatchedIssues(String comment, Pattern pIssue) {
        if (StringUtils.isEmpty((String)comment)) {
            return Collections.emptyList();
        }
        Matcher m = pIssue.matcher(comment);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group().trim());
        }
        return result;
    }

    public static boolean hasCommand(String str, Pattern pCommand, Pattern pIssue) {
        if (StringUtils.isBlank((String)str)) {
            return false;
        }
        Matcher m1 = pCommand.matcher(str);
        if (!m1.find()) {
            return false;
        }
        String sub = str.substring(m1.end());
        Matcher m2 = pIssue.matcher(sub);
        return m2.find();
    }

    public static List<CommitCommand> extractCommands(String text, Pattern pCommand, Pattern pIssue) {
        if (!CommandParser.hasCommand(text, pCommand, pIssue)) {
            return Collections.emptyList();
        }
        List<String> lines = CommandParser.extractCommandLines(text, pCommand, pIssue);
        if (lines.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CommitCommand> commands = new ArrayList<CommitCommand>();
        for (String line : lines) {
            List<CommitCommand> cmdsInLine = CommandParser.parseCommandLine(line, pCommand, pIssue);
            commands.addAll(cmdsInLine);
        }
        return commands;
    }

    private static boolean isSplitter(String str) {
        Matcher m = pSplitter.matcher(str);
        return m.find();
    }

    private static List<CommitCommand> parseCommandLine(String line, Pattern pCommand, Pattern pIssue) {
        if (!CommandParser.hasCommand(line, pCommand, pIssue)) {
            return Collections.emptyList();
        }
        ArrayList<CommitCommand> commands = new ArrayList<CommitCommand>();
        Matcher m = pParam.matcher(line);
        String part1 = line;
        String part2 = "";
        if (m.find()) {
            int pos = m.start();
            part1 = line.substring(0, pos);
            part2 = line.substring(pos);
        }
        String[] tokens = StringUtils.split((String)part1);
        CommandStatus status = CommandStatus.ACTION;
        LinkedHashSet<String> issues = new LinkedHashSet<String>();
        String action = "";
        for (int i = 0; i < tokens.length; ++i) {
            String str = tokens[i];
            switch (status) {
                case ACTION: {
                    m = pCommand.matcher(str);
                    if (!m.find()) break;
                    action = str;
                    status = CommandStatus.ISSUE_LIST;
                    break;
                }
                case ISSUE_LIST: {
                    m = pIssue.matcher(str);
                    boolean found = false;
                    while (m.find()) {
                        found = true;
                        issues.add(m.group().trim());
                    }
                    if (found || CommandParser.isSplitter(str)) break;
                    status = CommandStatus.ISSUE_END;
                    break;
                }
                case ISSUE_END: {
                    break;
                }
            }
            if (status == CommandStatus.ISSUE_END) break;
        }
        Map<String, String> options = CommandParser.parseOptions(part2);
        for (String each : issues) {
            CommitCommand command = new CommitCommand();
            command.setAction(action);
            command.setIssue(each);
            command.setOptions((Map<String, String>)CaseInsensitiveMap.of(options));
            commands.add(command);
        }
        return commands;
    }

    private static Map<String, String> parseOptions(String text) {
        CaseInsensitiveMap options = CaseInsensitiveMap.create();
        if (StringUtils.isBlank((String)text)) {
            return options;
        }
        int pos = 0;
        String previousOption = null;
        String value = "";
        Matcher m = pParam.matcher(text);
        while (m.find()) {
            String option = StringHelper.stripLeadingHyphens(m.group().trim());
            if (previousOption != null) {
                value = text.substring(pos, m.start());
                options.put(previousOption, value.trim());
            }
            previousOption = option;
            pos = m.end();
        }
        value = pos < text.length() ? text.substring(pos) : "";
        if (previousOption != null) {
            options.put(previousOption, value.trim());
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> extractCommandLines(String text, Pattern pCommand, Pattern pIssue) {
        ArrayList<String> result = new ArrayList<String>();
        String cmdLine = "";
        InputStreamReader coverter = new InputStreamReader(IOUtils.toInputStream((String)text));
        BufferedReader in = new BufferedReader(coverter);
        String line = "";
        try {
            boolean lineContinued = false;
            while ((line = in.readLine()) != null) {
                boolean cmdLineFound;
                Matcher m = pCommand.matcher(line);
                Matcher mIssue = pIssue.matcher(line);
                boolean bl = cmdLineFound = m.find() && mIssue.find();
                if (cmdLineFound) {
                    boolean bl2 = cmdLineFound = m.start() < mIssue.start();
                }
                if (cmdLineFound) {
                    int pos = m.start();
                    if (lineContinued && !StringUtils.isBlank((String)cmdLine)) {
                        cmdLine = cmdLine + "\n" + line.substring(0, pos).trim();
                        result.add(cmdLine);
                        lineContinued = false;
                    }
                    cmdLine = line.substring(m.start());
                    if ((cmdLine = cmdLine.trim()).endsWith("\\")) {
                        lineContinued = true;
                        cmdLine = cmdLine.substring(0, cmdLine.length() - 1);
                        continue;
                    }
                    result.add(cmdLine.trim());
                    cmdLine = "";
                    continue;
                }
                if (!lineContinued) continue;
                if (line.endsWith("\\")) {
                    cmdLine = cmdLine + "\n" + line.substring(line.length() - 1).trim();
                    continue;
                }
                cmdLine = cmdLine + "\n" + line.trim();
                result.add(cmdLine.trim());
                lineContinued = false;
                cmdLine = "";
            }
            if (lineContinued && !StringUtils.isBlank((String)cmdLine)) {
                result.add(cmdLine);
            }
        }
        catch (IOException e) {
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
        return result;
    }

    static enum CommandStatus {
        ACTION,
        ISSUE_LIST,
        ISSUE_END;

    }
}

