/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.generator.GeneratorContext;
import com.pmease.quickbuild.plugin.report.engine.generator.expression.ExpressionRule;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.util.ReportUtils;
import java.util.Collections;
import java.util.List;

public class IssueInBuildsRule
extends ExpressionRule {
    private static final long serialVersionUID = 1L;

    public IssueInBuildsRule(ReportCategory category) {
        super(category);
    }

    public void doExecute() {
        GeneratorContext context = this.getContext();
        DataRow row = context.getDestRow();
        Long buildId = Context.getBuild().getId();
        IssueInBuildsRule.addBuild(row, buildId);
    }

    public static void addBuild(DataRow row, Long buildId) {
        if (row == null) {
            return;
        }
        List inBuilds = (List)row.getValue("inBuilds");
        if (!inBuilds.contains(buildId)) {
            inBuilds = ReportUtils.limitAddingValue((List)inBuilds, (Object)buildId, (int)50, (boolean)false);
            Collections.sort(inBuilds);
            row.setValue("inBuilds", (Object)inBuilds);
        }
    }
}

