/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core;

import com.google.common.base.Strings;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataReport;
import com.pmease.quickbuild.plugin.report.engine.datareport.DataRow;
import com.pmease.quickbuild.plugin.report.engine.datastore.MergeFunction;
import com.pmease.quickbuild.plugin.report.engine.datastore.duplicate.AlwaysCurrent;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.report.engine.migration.MigrationContext;
import com.pmease.quickbuild.plugin.report.engine.migration.ReportCategoryMigrator;
import com.pmease.quickbuild.plugin.report.engine.renderer.AbstractRenderer;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.migration.IssueCategoryMigrator;
import com.pmease.quickbuild.plugin.tracker.core.renderer.IssueSummaryRenderer;
import com.pmease.quickbuild.plugin.tracker.core.renderer.SimpleIssueRenderer;
import com.pmease.quickbuild.util.LockUtils;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.locks.Lock;

public abstract class IssueCategory
extends ReportCategory {
    private static final long serialVersionUID = 1L;

    public abstract String getName();

    protected AbstractRenderer getIssueRenderer() {
        return new SimpleIssueRenderer(this);
    }

    public IssueCategory() {
        this.setOrder(150);
        this.onInitialize();
    }

    protected void onInitialize() {
        this.initFromClassResource(IssueCategory.class);
        if (Strings.isNullOrEmpty((String)this.getId())) {
            this.setId(Tab.title2id((String)this.getName()));
        }
        this.addRenderer(this.getBuildSummaryRenderer());
        this.addRenderer(this.getIssueRenderer());
    }

    protected AbstractRenderer getBuildSummaryRenderer() {
        IssueSummaryRenderer r = new IssueSummaryRenderer(this){
            private static final long serialVersionUID = 1L;

            @Override
            public String getTitle() {
                return IssueCategory.this.getBuildSummaryTitle();
            }
        };
        return r;
    }

    protected String getBuildSummaryTitle() {
        return this.getName() + " Issues";
    }

    public boolean hasUnProcessedReport() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getCategoryDirOfBuild(Build build) {
        File categoryDir = new File(build.getPublishDir(), "reports/" + this.getId());
        Lock lock = LockUtils.lockForRead((File)categoryDir);
        try {
            if (!categoryDir.exists() && build.getStatus() == Build.Status.RUNNING) {
                File file = categoryDir;
                return file;
            }
            MigrationContext context = new MigrationContext();
            context.setBuild(build);
            context.setDir(categoryDir);
            context.setCategory((ReportCategory)this);
            this.upgrade(categoryDir, context);
            File file = categoryDir;
            return file;
        }
        finally {
            lock.unlock();
        }
    }

    public Class<? extends ReportCategoryMigrator> getMigratorClass() {
        return IssueCategoryMigrator.class;
    }

    public String[] getReportSetsOfBuild(Build build) {
        super.getReportSetsOfBuild(build);
        return new String[]{"DEFAULT"};
    }

    public String[] getReportSetsOfStats(Configuration configuration) {
        super.getReportSetsOfStats(configuration);
        return new String[]{"DEFAULT"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIssues(Configuration configuration, Collection<Issue> issues) {
        File categoryDir = this.getCategoryDirOfStats(configuration);
        Lock lock = LockUtils.lockForRead((File)categoryDir);
        try {
            File dir = this.getReportDirOfStats(configuration, "DEFAULT");
            if (!dir.exists()) {
                return;
            }
            DataReport report = this.createReport("issues");
            for (Issue each : issues) {
                DataRow row = report.addRow();
                row.fromBean((Object)each, true);
            }
            this.saveReport(dir, report, (MergeFunction)new AlwaysCurrent());
        }
        finally {
            lock.unlock();
        }
    }
}

