/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.extensionpoint.BuildTabContribution;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.contribution.AbstractReportPlugin;
import com.pmease.quickbuild.plugin.report.engine.contribution.web.CategoryBuildTab;
import com.pmease.quickbuild.plugin.report.engine.metadata.ReportCategory;
import com.pmease.quickbuild.plugin.tracker.core.IssueCategory;
import com.pmease.quickbuild.plugin.tracker.core.contribution.IssueStatisticsProvider;
import com.pmease.quickbuild.plugin.tracker.core.contribution.IssuesBuildListener;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.IssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import com.pmease.quickbuild.pluginsupport.PluginCategory;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.web.component.tabbedpanel.GroupingTab;
import com.pmease.quickbuild.web.component.tabbedpanel.Tab;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

public abstract class AbstractTrackerPlugin
extends AbstractReportPlugin {
    public abstract IssueTracker createTracker();

    protected abstract IssueCategory createCategory();

    public abstract Class<?> getConfigurationSettingClass();

    public Object[] getExtensions() {
        ArrayList<Object> extensions = new ArrayList<Object>();
        IssueTracker tracker = this.createTracker();
        this.addExtension(extensions, tracker);
        this.addExtension(extensions, this.getRestContribution());
        if (tracker != null && tracker.isApplicable()) {
            extensions.add(this.createIssuesBuildListener());
            if (SecurityHelper.hasPermission((String)"VIEW_ISSUES")) {
                extensions.add(this.getBuildTabContribution());
                extensions.add(this.getBuildSummaryContribution());
            }
            extensions.add((Object)new IssueStatisticsProvider(){

                protected ReportCategory getCategory() {
                    return AbstractTrackerPlugin.this.getReportCategory();
                }
            });
        }
        extensions.addAll(this.getGadgetContributions());
        Object[] extras = this.getExtraExtensions();
        if (extras != null && extras.length > 0) {
            extensions.addAll(Arrays.asList(extras));
        }
        return extensions.toArray(new Object[extensions.size()]);
    }

    protected BuildTabContribution getBuildTabContribution() {
        return new CategoryBuildTab(){
            private static final long serialVersionUID = 1L;

            protected ReportCategory getCategory() {
                return AbstractTrackerPlugin.this.getReportCategory();
            }

            protected GroupingTab createGroupingTab(List<Tab> children) {
                return new GroupingTab(Tab.title2id((String)AbstractTrackerPlugin.this.getReportCategory().getName()), (IModel)new AbstractReadOnlyModel<String>(){
                    private static final long serialVersionUID = 1L;

                    public String getObject() {
                        long count = 0L;
                        if (ReportHelper.isShowReports((ReportCategory)this.getCategory())) {
                            count = AbstractTrackerPlugin.this.getIssueCount();
                        }
                        return AbstractTrackerPlugin.this.category.getName() + " (" + count + ")";
                    }
                }, children);
            }

            public boolean isApplicable() {
                return SecurityHelper.hasPermission((String)"VIEW_ISSUES");
            }
        };
    }

    protected IssuesBuildListener createIssuesBuildListener() {
        return new IssuesBuildListener(){

            @Override
            protected IssueTracker getTracker() {
                return AbstractTrackerPlugin.this.createTracker();
            }

            @Override
            protected ReportCategory getCategory() {
                return AbstractTrackerPlugin.this.getReportCategory();
            }

            public void buildRecommended() {
            }

            public void buildUnRecommended() {
            }
        };
    }

    protected Class<? extends Step> getPublishStepClass() {
        return null;
    }

    public PluginCategory getCategory() {
        return PluginCategory.TRACKER;
    }

    @ScriptApi(value="Get issues count in current build")
    public long getIssueCount() {
        return TrackerHelper.getIssueCount((IssueCategory)this.getReportCategory(), Context.getBuild());
    }
}

