/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.core;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.report.engine.ReportHelper;
import com.pmease.quickbuild.plugin.report.engine.datastore.DbStore;
import com.pmease.quickbuild.plugin.report.engine.datastore.SqlBuilder;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Filter;
import com.pmease.quickbuild.plugin.report.engine.datastore.filter.Restrictions;
import com.pmease.quickbuild.plugin.report.engine.metadata.CategoryDb;
import com.pmease.quickbuild.plugin.report.engine.renderer.ItemContext;
import com.pmease.quickbuild.plugin.report.engine.util.MapHelper;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.IssueCategory;
import com.pmease.quickbuild.plugin.tracker.core.TrackerException;
import com.pmease.quickbuild.plugin.tracker.core.commitcomand.CommandParser;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.Issue;
import com.pmease.quickbuild.plugin.tracker.core.extensionpoint.IssueTracker;
import com.pmease.quickbuild.plugin.tracker.core.setting.TrackerSetting;
import com.pmease.quickbuild.plugin.tracker.core.utils.TrackerHelper;
import com.pmease.quickbuild.pluginsupport.Plugin;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import com.pmease.quickbuild.security.SecurityHelper;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIssueTracker
implements IssueTracker,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractIssueTracker.class);

    protected Class<? extends AbstractTrackerPlugin> getTrackerPluginClass() {
        Plugin plugin = PluginManager.instance.getDeclaringPlugin(this.getClass());
        return plugin.getClass();
    }

    public boolean isApplicable() {
        return this.getSetting(Context.getConfiguration()) != null;
    }

    public TrackerSetting getSetting(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        return (TrackerSetting)PluginSettingHelper.findConfigurationSetting(this.getTrackerPluginClass(), (Configuration)configuration, (boolean)true);
    }

    protected IssueCategory getCategory() {
        return (IssueCategory)ReportHelper.getCategory(this.getTrackerPluginClass());
    }

    @Override
    public String extractIssueKey(String matched) {
        if (matched != null) {
            return matched.trim();
        }
        return null;
    }

    public List<String> extractIssueKeys(String message) {
        if (StringUtils.isBlank((String)message)) {
            return Collections.emptyList();
        }
        Pattern pIssue = this.getIssuePattern();
        List<String> matched = CommandParser.getMatchedIssues(message, pIssue);
        HashSet<String> result = new HashSet<String>();
        for (String each : matched) {
            result.add(this.extractIssueKey(each));
        }
        return new ArrayList<String>(result);
    }

    @Override
    public int getIssueCount(Build build) {
        if (build == null) {
            return 0;
        }
        if (this.getSetting(build.getConfiguration()) == null) {
            return 0;
        }
        IssueCategory category = this.getCategory();
        return Long.valueOf(TrackerHelper.getIssueCount(category, build)).intValue();
    }

    public final Issue fetchIssue(String issueKey) {
        Map<String, Issue> issues = this.fetchIssues(Arrays.asList(issueKey));
        return issues.get(issueKey);
    }

    @Override
    public Pattern getIssuePattern() {
        return Pattern.compile(this.getSetting(Context.getConfiguration()).getIssuePattern());
    }

    public String formatIssueLink(String issueKey, String linkContent) {
        StringBuffer sb = new StringBuffer();
        sb.append("<a target=\"_blank\" href=\"").append(this.getIssueUrlPattern().replace("$KEY", issueKey)).append("\">").append(linkContent).append("</a>");
        return sb.toString();
    }

    public String transform(String comment, Map<String, Object> data) {
        if (!SecurityHelper.hasPermission((String)"VIEW_ISSUES")) {
            return comment;
        }
        Pattern pIssue = this.getIssuePattern();
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = pIssue.matcher(comment);
        String urlPattern = this.getIssueUrlPattern();
        List<String> keys = this.extractIssueKeys(comment);
        if (keys.isEmpty()) {
            return comment;
        }
        Map<String, Issue> issues = this.getCachedIssues(keys, data);
        while (matcher.find()) {
            String matchedKey = matcher.group();
            String issueKey = this.extractIssueKey(matchedKey);
            Issue issue = issues.get(issueKey);
            String link = null;
            if (issue != null) {
                StringBuffer sb = new StringBuffer();
                sb.append("<a target=\"_blank\" href=\"").append(urlPattern.replace("$KEY", issueKey)).append("\" ").append("class='issue-link' ");
                if (!StringUtils.isBlank((String)issue.getSummary())) {
                    String summary = issue.getSummary();
                    summary = StringUtils.replace((String)summary, (String)"\"", (String)"&quot;");
                    sb.append("title=\"").append(summary).append("\"");
                }
                sb.append(">").append(matchedKey).append("</a>");
                link = sb.toString();
            }
            if (link == null) continue;
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(link));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Issue> getCachedIssues(List<String> keys, Map<String, Object> data) {
        String cachedName = this.getClass().getName() + ".issues";
        HashMap<String, Issue> cached = (HashMap<String, Issue>)data.get(cachedName);
        if (cached == null) {
            cached = new HashMap<String, Issue>();
            data.put(cachedName, cached);
        }
        LinkedHashSet<String> fromDb = new LinkedHashSet<String>();
        for (String each : keys) {
            Issue issue = (Issue)cached.get(each);
            if (issue != null) continue;
            fromDb.add(each);
        }
        LinkedHashSet<String> fromRemote = new LinkedHashSet<String>();
        ItemContext ic = (ItemContext)data.get("commentitem.context");
        Configuration configuration = ic.getConfiguration();
        IssueCategory category = this.getCategory();
        if (!fromDb.isEmpty()) {
            File dbDir = category.getReportDirOfStats(configuration, "DEFAULT");
            if (dbDir.exists()) {
                CategoryDb db = category.getCategoryDb(dbDir);
                try {
                    db.open(DbStore.Mode.READ_ONLY, "AbstractIssueTracker::getCachedIssues");
                    for (String each : fromDb) {
                        SqlBuilder query = SqlBuilder.query().select(new String[]{"*"}).from(new String[]{"issues"}).where(new Filter[]{Restrictions.eq((String)"issueKey", (Object)each)}).limit(1);
                        Map map = db.queryForMap(query);
                        if (map == null || map.isEmpty()) {
                            fromRemote.add(each);
                            continue;
                        }
                        Issue issue = new Issue();
                        MapHelper.mapToBean((Map)map, (Object)issue);
                        if (Strings.isNullOrEmpty((String)issue.getSummary())) {
                            fromRemote.add(each);
                            continue;
                        }
                        cached.put(each, issue);
                    }
                }
                finally {
                    db.close();
                }
            } else {
                fromRemote = fromDb;
            }
        }
        if (!fromRemote.isEmpty()) {
            try {
                logger.debug("Retrieved from remote server [" + StringUtils.join(fromRemote, (String)", ") + "].");
                Map<String, Issue> retrieved = this.fetchIssues(fromRemote);
                if (retrieved != null && !retrieved.isEmpty()) {
                    logger.debug("Updating issues database ...");
                    ArrayList fetchedIssues = Lists.newArrayList(retrieved.values());
                    Long buildId = MapUtils.getLong((Map)ic.getExpressionContext(), (Object)"buildId", (Long)0L);
                    for (Issue each : fetchedIssues) {
                        each.setBuildId(buildId);
                    }
                    category.updateIssues(Context.getConfiguration(), retrieved.values());
                    cached.putAll(retrieved);
                }
            }
            catch (TrackerException e) {
                logger.error("Failed retrieving issues.", (Throwable)e);
            }
        }
        return cached;
    }
}

