/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis.web;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.util.time.Duration;

public class HttpPanel
extends Panel {
    private WebMarkupContainer container = new WebMarkupContainer("container");

    public HttpPanel(String id, final String url, int refreshInterval) {
        super(id);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        WebMarkupContainer frame = new WebMarkupContainer("frame"){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("src", (CharSequence)url);
            }
        };
        this.container.add(new Component[]{frame});
        if (refreshInterval != 0) {
            this.setOutputMarkupId(true);
            this.add(new Behavior[]{new AjaxSelfUpdatingTimerBehavior(Duration.seconds((int)refreshInterval))});
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        String script = "function adjustFrameHeight() {$('#%s').height($(window).height()-$('#%s').offset().top-56)};adjustFrameHeight();$(window).bind('resize', adjustFrameHeight);";
        response.renderOnLoadJavaScript(String.format(script, this.container.getMarkupId(), this.container.getMarkupId()));
    }
}

