/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis.web;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.util.DateUtils;
import com.pmease.quickbuild.web.behavior.RefreshBehavior;
import com.pmease.quickbuild.web.component.InternalImage;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.build.BuildPage;
import com.pmease.quickbuild.web.page.configuration.ConfigurationOverview;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.visit.IVisit;

public class FailedBuildsPanel
extends Panel {
    private Long treeId;
    private Set<Long> lastFailedBuildIds;

    public FailedBuildsPanel(String id, Configuration tree) {
        super(id);
        if (tree != null) {
            this.treeId = tree.getId();
        }
        this.setDefaultModel((IModel)new LoadableDetachableModel<List<Build>>(){

            protected List<Build> load() {
                Map latestBuilds = CacheManager.instance.getLatestBuilds();
                if (FailedBuildsPanel.this.treeId != null) {
                    Set descendantIds = CacheManager.instance.getDescendentIds(FailedBuildsPanel.this.treeId);
                    Iterator it = latestBuilds.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        if (descendantIds.contains(entry.getKey())) continue;
                        it.remove();
                    }
                }
                Iterator it = latestBuilds.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Build build = (Build)entry.getValue();
                    if (!build.isRunning() && !build.isSuccessful() && !build.isRecommended()) continue;
                    it.remove();
                }
                ArrayList<Build> failedBuilds = new ArrayList<Build>(latestBuilds.values());
                Collections.sort(failedBuilds, new Comparator<Build>(){

                    @Override
                    public int compare(Build o1, Build o2) {
                        return o1.getConfiguration().getId().compareTo(o2.getConfiguration().getId());
                    }
                });
                return failedBuilds;
            }
        });
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new ListView<Build>("failedBuilds", (IModel)new AbstractReadOnlyModel<List<Build>>(){

            public List<Build> getObject() {
                return FailedBuildsPanel.this.getFailedBuilds();
            }
        }){

            protected void populateItem(ListItem<Build> item) {
                Build build = (Build)item.getModelObject();
                Configuration configuration = (Configuration)BasePage.get().getConfigurations().get(build.getConfiguration().getId());
                BookmarkablePageLink link = new BookmarkablePageLink("configurationLink", ConfigurationOverview.class, ConfigurationOverview.params4((Long)configuration.getId()));
                link.add(new Component[]{new Label("label", configuration.getPathName())});
                item.add(new Component[]{link});
                String icon = build.getStatus() == Build.Status.CANCELLED ? "/images/cancelled.gif" : (build.getStatus() == Build.Status.TIMEOUT ? "/images/timeout.gif" : "/images/red-ball.gif");
                item.add(new Component[]{new InternalImage("statusIcon", icon)});
                link = new BookmarkablePageLink("buildLink", BuildPage.class, BuildPage.params4((Long)build.getId()));
                link.add(new Component[]{new Label("label", build.getVersion())});
                item.add(new Component[]{link});
                item.add(new Component[]{new Label("status", build.getStatus().name())});
                item.add(new Component[]{new Label("date", DateUtils.formatAge((Date)build.getEndDate()))});
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("noFailures"){

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(FailedBuildsPanel.this.getFailedBuilds().isEmpty());
            }
        }});
        this.setOutputMarkupId(true);
        this.add(new Behavior[]{new RefreshBehavior(){

            public boolean needRefresh(IVisit<Void> visit, Date lastRefreshDate) {
                if (FailedBuildsPanel.this.lastFailedBuildIds == null) {
                    return true;
                }
                HashSet<Long> failedBuildIds = new HashSet<Long>();
                for (Build build : FailedBuildsPanel.this.getFailedBuilds()) {
                    failedBuildIds.add(build.getId());
                }
                return !((Object)failedBuildIds).equals(FailedBuildsPanel.this.lastFailedBuildIds);
            }
        }});
    }

    protected void onBeforeRender() {
        this.lastFailedBuildIds = new HashSet<Long>();
        for (Build build : this.getFailedBuilds()) {
            this.lastFailedBuildIds.add(build.getId());
        }
        super.onBeforeRender();
    }

    private List<Build> getFailedBuilds() {
        return (List)this.getDefaultModelObject();
    }
}

