/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.basis.TriggerBuildStep;
import java.io.Serializable;
import org.hibernate.validator.constraints.NotEmpty;

public class TriggerServer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TriggerBuildStep step;
    private String url;
    private String userName;
    private String password;

    @Editable(order=100, description="Specify server url. For example: <em>http://server-host-name:8810</em>")
    @Scriptable
    @NotEmpty
    @ScriptApi(value="Get url of this server.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Editable(order=200, description="Specify user name to login to the server. Server will be accessed anonymously if user name is not specified.")
    @Scriptable
    @ScriptApi(value="Get user name to login to the server. Null for anonymous access.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=300, description="Specify password for above user.")
    @Scriptable
    @Password
    @ScriptApi(value="Get password to login to the server.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public TriggerServer(TriggerBuildStep step) {
        this.step = step;
    }

    @ScriptApi(value="Get associated step object.")
    public TriggerBuildStep getStep() {
        return this.step;
    }
}

