/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis;

import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.RequestResult;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.ConfigurationPath;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.BuildManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.NodeService;
import com.pmease.quickbuild.grid.ServerService;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.basis.TriggerServer;
import com.pmease.quickbuild.plugin.basis.waitcondition.AlwaysWait;
import com.pmease.quickbuild.plugin.basis.waitcondition.WaitCondition;
import com.pmease.quickbuild.rest.RestModule;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.EasyList;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.page.build.StepBuildInfoPanel;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import javax.validation.constraints.NotNull;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Trigger Other Builds", description="Trigger builds of choosed configurations at this server or another server.")
@ScriptApi(value="Trigger build in specified configurations.")
public class TriggerBuildStep
extends Step {
    private static final long serialVersionUID = 1L;
    private TriggerServer server;
    private String configurationPath;
    private List<Property> variables = new ArrayList<Property>();
    private boolean respectBuildCondition;
    private WaitCondition waitCondition = new AlwaysWait();
    private boolean waitForStart = false;

    @Editable(order=100, description="Check this if you want to trigger builds on another QuickBuild server. Configurations specified below will be considered to reside on the specified server if this option is checked.")
    @ScriptApi(value="Get the server at which to trigger the builds. Null if trigger builds at current server.")
    public TriggerServer getServer() {
        return this.server;
    }

    public void setServer(TriggerServer server) {
        this.server = server;
    }

    @Editable(order=200, name="Configuration", description="Specify the configuration in which to trigger build.")
    @ConfigurationPath
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get configuration path to trigger build for.")
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    @Editable(order=450, description="Define variables to be used in triggered build. Please note that variables defined here will override variables defined in the configuration specified above.")
    @ScriptApi(value="Get list of variables passed to build process.")
    public List<Property> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Property> variables) {
        this.variables = variables;
    }

    @Editable(name="Respect Build Condition", order=460, description="Whether or not to respect build condition of the triggered configuration. If not, build in the specified configuration will always be generated and run.")
    public boolean isRespectBuildCondition() {
        return this.respectBuildCondition;
    }

    public void setRespectBuildCondition(boolean respectBuildCondition) {
        this.respectBuildCondition = respectBuildCondition;
    }

    @Editable(name="Wait For Finishing", order=500, description="Whether or not to wait for finishing of triggered builds. If set to wait, this step will fail if any of the triggered builds are failed.")
    @NotNull
    @ScriptApi(value="Get the wait condition. This condition determines whether or not to wait for finishing of triggered builds.")
    @Scriptable
    public WaitCondition getWaitCondition() {
        return this.waitCondition;
    }

    public void setWaitCondition(WaitCondition waitCondition) {
        this.waitCondition = waitCondition;
    }

    @Editable(name="Wait For Start", description="Only takes effect when this step does not wait for finishingof the triggered build. In that case, enable this option cause the step to wait for start of build so that it can record id of newly triggered build.")
    @Advanced
    public boolean isWaitForStart() {
        return this.waitForStart;
    }

    public void setWaitForStart(boolean waitForStart) {
        this.waitForStart = waitForStart;
    }

    public void run() {
        HashMap<String, String> variableMap = new HashMap<String, String>();
        for (Property property : this.getVariables()) {
            variableMap.put(property.getName(), property.getValue());
        }
        boolean wait = this.getWaitCondition().satisfied(this);
        Build build = Context.getBuild();
        if (this.getServer() != null) {
            WebResource resource = RestModule.resource((String)this.getServer().getUrl(), (String)"rest/ids", (String)this.getServer().getUserName(), (String)this.getServer().getPassword());
            ClientResponse response = (ClientResponse)resource.queryParam("configuration_path", this.getConfigurationPath()).get(ClientResponse.class);
            if (response.getStatus() == 204) {
                throw new QuickbuildException("Configuration '" + this.getConfigurationPath() + "' not found at server '" + this.getServer().getUrl() + "'.");
            }
            if (response.getStatus() != 200) {
                throw new QuickbuildException("Error querying id of configuration '" + this.getConfigurationPath() + "' at server '" + this.getServer().getUrl() + "': " + (String)response.getEntity(String.class));
            }
            Long configurationId = (Long)response.getEntity(Long.class);
            resource = RestModule.resource((String)this.getServer().getUrl(), (String)"rest/build_requests", (String)this.getServer().getUserName(), (String)this.getServer().getPassword());
            BuildRequest request = new BuildRequest();
            request.setConfigurationId(configurationId);
            request.setRespectBuildCondition(this.isRespectBuildCondition());
            request.getVariables().putAll(variableMap);
            if (wait) {
                request.getUpstreamRequestIds().add(build.getRequest().getId());
                RequestResult result = (RequestResult)resource.post(RequestResult.class, (Object)request);
                if (!result.isLoopedRequest()) {
                    resource = RestModule.resource((String)this.getServer().getUrl(), (String)"rest/ids", (String)this.getServer().getUserName(), (String)this.getServer().getPassword()).queryParam("request_id", result.getRequestId());
                    response = (ClientResponse)resource.get(ClientResponse.class);
                    while (response.getStatus() == 204) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            resource = RestModule.resource((String)this.getServer().getUrl(), (String)("rest/build_requests/" + result.getRequestId()), (String)this.getServer().getUserName(), (String)this.getServer().getPassword());
                            resource.delete();
                            throw new RuntimeException(e);
                        }
                        response = (ClientResponse)resource.get(ClientResponse.class);
                    }
                    if (response.getStatus() != 200) {
                        throw new RuntimeException("Error retrieving id of triggered build: " + (String)response.getEntity(String.class));
                    }
                    Long buildId = (Long)response.getEntity(Long.class);
                    resource = RestModule.resource((String)this.getServer().getUrl(), (String)("rest/builds/" + buildId + "/status"), (String)this.getServer().getUserName(), (String)this.getServer().getPassword());
                    Build.Status buildStatus = (Build.Status)resource.get(Build.Status.class);
                    while (buildStatus == Build.Status.RUNNING) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            resource = RestModule.resource((String)this.getServer().getUrl(), (String)("rest/build_requests/" + result.getRequestId()), (String)this.getServer().getUserName(), (String)this.getServer().getPassword());
                            resource.delete();
                            throw new RuntimeException(e);
                        }
                        buildStatus = (Build.Status)resource.get(Build.Status.class);
                    }
                    if (buildStatus == null) {
                        throw new QuickbuildException(ExceptionUtils.buildMessage((String)"Triggered build not found", (Object[])new Object[]{"server", this.getServer().getUrl(), "configuration", this.getConfigurationPath(), "build id", buildId}));
                    }
                    if (buildStatus == Build.Status.FAILED || buildStatus == Build.Status.CANCELLED || buildStatus == Build.Status.TIMEOUT) {
                        throw new QuickbuildException("Step is failed since the triggered build is failed, cancelled, or timed out.");
                    }
                } else {
                    Context.getLogger().warn("Looped build request found for configuration '" + this.getConfigurationPath() + "' at server '" + this.getServer().getUrl() + "'. Will not wait for finish of requested build.");
                }
            } else {
                response = (ClientResponse)resource.post(ClientResponse.class, (Object)request);
                if (response.getStatus() == 204) {
                    Context.getLogger().warn("Build request was aggregated.");
                } else if (response.getStatus() != 200) {
                    throw new RuntimeException("Error requesting build: " + (String)response.getEntity(String.class));
                }
            }
        } else {
            ConfigurationManager configurationManager = (ConfigurationManager)Quickbuild.getInstance(ConfigurationManager.class);
            Configuration configuration = configurationManager.get(this.getConfigurationPath());
            if (configuration == null) {
                throw new QuickbuildException("Can not find configuration '" + this.getConfigurationPath() + "'.");
            }
            ServerService serverService = Quickbuild.getServerService();
            NodeService nodeService = Grid.instance.getLocalNode().getNodeService();
            Long requesterId = build.getRequester() != null ? build.getRequester().getId() : null;
            BuildRequest request = new BuildRequest();
            request.setConfigurationId(configuration.getId());
            request.setUpstreamConfigurationId(Context.getConfiguration().getId());
            request.setRespectBuildCondition(this.isRespectBuildCondition());
            request.getVariables().putAll(variableMap);
            if (wait) {
                request.getUpstreamRequestIds().add(build.getRequest().getId());
                RequestResult result = serverService.requestBuild(requesterId, build.isScheduled(), request);
                String nodeAddress = Grid.instance.getLocalNode().getAddress();
                if (!result.isLoopedRequest()) {
                    if (Context.getConfiguration().findAuditBuildRequest().booleanValue()) {
                        Quickbuild.getServerService().audit(requesterId, configuration.getPathName() + "/", "Build request was submitted via \"trigger other builds\" step in build '" + build.getVersion() + "' of configuration '" + build.getConfiguration() + "'.", null, null);
                    }
                    Long buildId = serverService.getBuildId(result.getRequestId(), nodeAddress);
                    while (buildId == null) {
                        try {
                            buildId = nodeService.getBuildId(result.getRequestId(), 300000L);
                        }
                        catch (Exception e) {
                            serverService.cancelBuildRequest(this.getBuild().getRequest().getId(), result.getRequestId());
                            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
                        }
                        if (buildId != null) continue;
                        Context.getLogger().trace("Triggered build id not found in cache, continue to query from server...");
                        buildId = serverService.getBuildId(result.getRequestId(), nodeAddress);
                    }
                    this.getRuntime().setCustomData((Object)buildId);
                    serverService.stepUpdated(Context.getBuild().getId(), this.getPath(), this.getRuntime());
                    Build.Status buildStatus = serverService.getBuildStatus(buildId, nodeAddress);
                    while (buildStatus == Build.Status.RUNNING) {
                        try {
                            buildStatus = nodeService.getBuildStatus(buildId, 300000L);
                        }
                        catch (Exception e) {
                            serverService.cancelBuildRequest(this.getBuild().getRequest().getId(), result.getRequestId());
                            throw ExceptionUtils.wrapAsUnchecked((Throwable)e);
                        }
                        if (buildStatus != null) continue;
                        Context.getLogger().trace("Status of triggered build not found in cache, querying from database...");
                        buildStatus = serverService.getBuildStatus(buildId, nodeAddress);
                    }
                    if (buildStatus == null) {
                        throw new QuickbuildException(ExceptionUtils.buildMessage((String)"Triggered build not found", (Object[])new Object[]{"configuration", this.getConfigurationPath(), "build id", buildId}));
                    }
                    if (buildStatus == Build.Status.FAILED || buildStatus == Build.Status.CANCELLED || buildStatus == Build.Status.TIMEOUT) {
                        throw new QuickbuildException("Step is failed since the triggered build is failed, cancelled, or timed out.");
                    }
                } else {
                    Context.getLogger().warn("Looped build request found for configuration '" + this.getConfigurationPath() + "'. Will not wait for finish of requested build.");
                }
            } else {
                RequestResult result = serverService.requestBuild(requesterId, build.isScheduled(), request);
                if (result.getRequestId() == null) {
                    Context.getLogger().warn("Unable to trigger build for configuration '{}': {}", (Object)configuration.getPathName(), (Object)result.getRejectReason());
                } else {
                    if (configuration.findAuditBuildRequest().booleanValue()) {
                        Quickbuild.getServerService().audit(requesterId, configuration.getPathName() + "/", "Build was requested via \"trigger other builds\" step in build '" + build.getVersion() + "' of configuration '" + build.getConfiguration() + "'.", null, null);
                    }
                    if (this.isWaitForStart()) {
                        String nodeAddress = Grid.instance.getLocalNode().getAddress();
                        Long buildId = serverService.getBuildId(result.getRequestId(), nodeAddress);
                        while (buildId == null) {
                            buildId = nodeService.getBuildId(result.getRequestId(), 300000L);
                            if (buildId != null) continue;
                            Context.getLogger().trace("Triggered build id not found in cache, continue to query from server...");
                            buildId = serverService.getBuildId(result.getRequestId(), nodeAddress);
                        }
                        this.getRuntime().setCustomData((Object)buildId);
                        serverService.stepUpdated(Context.getBuild().getId(), this.getPath(), this.getRuntime());
                    }
                }
            }
        }
    }

    public Component renderCustomRuntimeData(String panelId, Object customRuntimeData) {
        final Long buildId = (Long)customRuntimeData;
        return new StepBuildInfoPanel(panelId, "Triggered build: ", (IModel)new LoadableDetachableModel<List<Build>>(){

            protected List<Build> load() {
                BuildManager buildManager = (BuildManager)Quickbuild.getInstance(BuildManager.class);
                Build build = (Build)buildManager.get(buildId);
                if (build != null) {
                    return EasyList.create((Object[])new Build[]{build});
                }
                return EasyList.create((Object[])new Object[0]);
            }
        });
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element passwordElement;
        Element userNameElement;
        Element serverUrlElement;
        String serverUrl = dom.getValue("serverUrl");
        if (serverUrl != null) {
            String password;
            Element serverElement = dom.getRootElement().addElement("server");
            serverElement.addElement("step").addAttribute("reference", "../..");
            serverElement.addElement("url").setText(serverUrl);
            String userName = dom.getValue("userName");
            if (userName != null) {
                serverElement.addElement("userName").setText(userName);
            }
            if ((password = dom.getValue("password")) != null) {
                serverElement.addElement("password").setText(password);
            }
        }
        if ((serverUrlElement = dom.getRootElement().element("serverUrl")) != null) {
            serverUrlElement.detach();
        }
        if ((userNameElement = dom.getRootElement().element("userName")) != null) {
            userNameElement.detach();
        }
        if ((passwordElement = dom.getRootElement().element("password")) != null) {
            passwordElement.detach();
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        Element element = dom.getRootElement().element("waitForFinish");
        if (element.getTextTrim().equals("true")) {
            dom.getRootElement().addElement("waitCondition").setText("true");
        } else {
            dom.getRootElement().addElement("waitCondition").setText("false");
        }
        element.detach();
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        Element element = dom.getRootElement().element("configurationPaths");
        dom.getRootElement().addElement("configurationPath").setText(element.getText());
        element.detach();
        dom.getRootElement().addElement("successCondition").setText("triggeredBuild.successful");
    }

    private void migrate4(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().element("successCondition").detach();
    }

    private void migrate5(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate6(VersionedDocument dom, Stack<Integer> versions) {
        Element waitConditionElement = dom.getRootElement().element("waitCondition");
        String waitCondition = waitConditionElement.getText().trim();
        waitConditionElement.clearContent();
        if (waitCondition.equals("true")) {
            waitConditionElement.addAttribute("class", "com.pmease.quickbuild.plugin.basis.waitcondition.AlwaysWait");
        } else if (waitCondition.equals("false")) {
            waitConditionElement.addAttribute("class", "com.pmease.quickbuild.plugin.basis.waitcondition.NeverWait");
        } else {
            waitConditionElement.addAttribute("class", "com.pmease.quickbuild.plugin.basis.waitcondition.ScriptWaitCondition").addElement("script").setText(waitCondition);
        }
    }

    private void migrate7(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("respectBuildCondition").setText("false");
    }

    private void migrate8(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("waitForStart").setText("false");
    }
}

