/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.annotation.Template;
import com.pmease.quickbuild.log.VelocityLogger;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.VelocityUtils;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Stack;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Evaluate Velocity Template", category={"Misc"}, description="This step evaluates specified Velocity template and save the evaluation result as a file.")
@ScriptApi(value="Evaluate specified template and save evaluation result to specified file.")
public class TemplateEvalStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String template;
    private String saveAs;

    @Editable(order=1000, description="Specify a <a href=\"http://velocity.apache.org\">Velocity</a> template here. Evaluation result of the template will be saved to the file specified below. Resource load path will be set to current configuration's workspace directory when this template is evaluated. Also refer to template context help below for objects contained in the Velocity context.")
    @NotEmpty
    @Multiline(value=10)
    @ScriptApi(value="Get template to evaluate.")
    @Template
    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @Editable(order=1100, description="Specify the file path relative to current workspace which is used to save the template evaluation result.")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get file path to save evaluation result as.")
    public String getSaveAs() {
        return this.saveAs;
    }

    public void setSaveAs(String saveAs) {
        this.saveAs = saveAs;
    }

    public void run() {
        try {
            VelocityEngine engine = new VelocityEngine();
            engine.setProperty("file.resource.loader.path", (Object)Context.getConfiguration().getWorkspaceDir().getAbsolutePath());
            engine.setProperty("runtime.log.logsystem", (Object)new VelocityLogger());
            engine.init();
            StringWriter writer = new StringWriter();
            VelocityContext evalContext = VelocityUtils.buildEvalContext((Map)Context.buildEvalContext((Object)((Object)this), null));
            engine.evaluate((org.apache.velocity.context.Context)evalContext, (Writer)writer, "velocity", this.template);
            FileUtils.writeFile((File)new File(Context.getConfiguration().getWorkspaceDir(), this.getSaveAs()), (String)writer.toString());
        }
        catch (Exception e) {
            throw ExceptionUtils.wrapException((String)"Failed to evaluate Velocity template.", (Throwable)e);
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
        }
    }
}

