/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.annotation.Template;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.plugin.basis.Attachment;
import com.pmease.quickbuild.setting.system.EmailSetting;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.MiscUtils;
import com.pmease.quickbuild.util.VelocityUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Send Email", category={"Misc"}, description="This step sends arbitrary email to specified addresses with specified content.")
@ScriptApi(value="Send email to specified addresses with specified content.")
public class SendMailStep
extends Step {
    private String toList;
    private String ccList;
    private String emailSubject;
    private String emailBody;
    private List<Attachment> attachments = new ArrayList<Attachment>();

    @Editable(order=90, description="Specify to list of this email. Multiple addresses should be separated by comma.")
    @Scriptable
    @NotEmpty
    public String getToList() {
        return this.toList;
    }

    public void setToList(String toList) {
        this.toList = toList;
    }

    @Editable(order=95, description="Optionally specify cc list of this email. Multiple addresses should be separated by comma.")
    @Scriptable
    public String getCcList() {
        return this.ccList;
    }

    public void setCcList(String ccList) {
        this.ccList = ccList;
    }

    @Editable(order=100, description="Specify subject of the email.")
    @NotEmpty
    @ScriptApi(value="Get subject of the email.")
    @Scriptable
    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    @Editable(order=200, description="Specify a <a href=\"http://velocity.apache.org\">Velocity</a> template here. Evaluation result of the template will be used as body of the email. The resource load path will be set to the <em>asset</em> sub folder under QuickBuild server's installation directory when this template is evaluated. Also refer to template context help below for objects contained in the Velocity context.")
    @Multiline(value=10)
    @NotEmpty
    @ScriptApi(value="Get body template of the email.")
    @Template
    public String getEmailBody() {
        return this.emailBody;
    }

    public void setEmailBody(String emailBody) {
        this.emailBody = emailBody;
    }

    @Editable(order=300, description="Specify email attachments.")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void run() {
        ArrayList<File> attachments = new ArrayList<File>();
        for (Attachment attachment : this.getAttachments()) {
            File baseDir = FileUtils.resolvePath((File)this.getBuild().getConfiguration().getWorkspaceDir(), (String)attachment.getSrcPath());
            for (File each : FileUtils.listFiles((File)baseDir, (String)attachment.getFilePatterns())) {
                if (!each.isFile()) continue;
                attachments.add(each);
            }
        }
        EmailSetting emailSetting = SettingManager.instance.getEmailSetting();
        if (emailSetting == null) {
            throw new QuickbuildException("Can not send email as mail server is not configured. To configure mail server, please login as administrator and open page Administration/Email Setting");
        }
        MiscUtils.sendMail((String)this.getToList(), (String)this.getCcList(), (String)this.getEmailSubject(), (String)VelocityUtils.evalTemplate((String)this.getEmailBody(), (Map)Context.buildEvalContext((Object)((Object)this), null)), attachments, (EmailSetting)emailSetting, (String)"text/html");
    }
}

