/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.stepsupport.RepositoryStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Promote StarTeam Label", category={"Repository"}, description="Promote label on a StarTeam repository")
@ScriptApi(value="Promote a StarTeam label.")
public class PromoteLabelStep
extends RepositoryStep {
    private static final long serialVersionUID = 1L;
    private String label;
    private String destination;

    @Editable(name="Promote Label on", order=1000, description="Specify a StarTeam repository to promote label against.")
    @ChoiceProvider(value="getAvailableRepositoryNames")
    @NotEmpty
    @ScriptApi(value="Get name of the repository to promote label against.")
    public String getRepositoryName() {
        return super.getRepositoryName();
    }

    private static List<String> getAvailableRepositoryNames() {
        Set availableRepositoryNames = Context.getConfiguration().findRepositoryNames();
        return new ArrayList<String>(availableRepositoryNames);
    }

    @Editable(order=1010, name="Label Name", description="Specify name of the label which will be promoted on the repository")
    @NotEmpty
    @ScriptApi(value="Get label to promote.")
    @Scriptable
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Editable(order=1020, name="Promotion State", description="Specify label promotion state.")
    @NotEmpty
    @ScriptApi(value="Get new label promotion state.")
    @Scriptable
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void run() {
        this.getRepository().promoteLabel(this.getLabel(), this.getDestination());
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
            versions.push(0);
        }
    }
}

