/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.ConfigurationBasedGadget;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.web.page.configuration.pipeline.PipelinePanel;
import java.util.Stack;
import javax.validation.constraints.Min;
import org.apache.wicket.markup.html.panel.Panel;

@Editable(name="Build Pipeline", order=15, category={"Configuration and Build"})
public class PipelineGadget
extends ConfigurationBasedGadget {
    private boolean showBuildFilter;
    private boolean showPageNavigator = true;
    private int pageSize = 5;

    @Editable(order=200, description="Whether or not to show build filter.")
    public boolean isShowBuildFilter() {
        return this.showBuildFilter;
    }

    public void setShowBuildFilter(boolean showBuildFilter) {
        this.showBuildFilter = showBuildFilter;
    }

    @Editable(order=300, description="Whether or not to show page navigator.")
    public boolean isShowPageNavigator() {
        return this.showPageNavigator;
    }

    public void setShowPageNavigator(boolean showPageNavigator) {
        this.showPageNavigator = showPageNavigator;
    }

    @Editable(order=400, description="Specify how many builds to show in a page.")
    @Min(value=1L)
    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    protected Panel renderBodyForConfiguration(String panelId) {
        return new PipelinePanel(panelId, this.showBuildFilter, this.showPageNavigator, this.pageSize);
    }

    public String getCssClass() {
        return "pipeline-gadget";
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("pageSize").setText("5");
        dom.getRootElement().addElement("showBuildFilter").setText("false");
        dom.getRootElement().addElement("showPageNavigator").setText("true");
    }
}

