/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.dashboard.DashboardPage;
import java.io.Serializable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.time.Duration;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Editable(name="Html Message", order=100000, category={"Others"})
public class MessageGadget
extends Gadget {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(MessageGadget.class);
    private String message;
    private int refreshInterval;

    @Editable(name="Message", order=100, description="Specify a message to display. Html tags can be used to format the message.")
    @NotEmpty
    @Multiline
    @Scriptable
    public String getMessage() {
        return this.message;
    }

    public String getCssClass() {
        return "window";
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Editable(name="Refresh Interval", order=200, description="Specify auto-refresh interval in seconds for this gadget. Auto refresh will be disabled if this value is set to <tt>0</tt>.")
    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public Component renderBody(String componentId) {
        DashboardPage page = (DashboardPage)BasePage.get();
        Component body = SecurityHelper.isScriptAllowed((User)page.getActiveDashboard().getUser()) ? new Label(componentId, (IModel)new LoadableDetachableModel<String>(){
            private static final long serialVersionUID = 1L;

            protected String load() {
                try {
                    return ScriptEngine.instance.interpolate(MessageGadget.this.getMessage(), Context.buildEvalContext(null, null));
                }
                catch (Exception e) {
                    logger.error("Error interpolating message.", (Throwable)e);
                    String message = StringEscapeUtils.escapeHtml((String)ExceptionUtils.extractImportantMessage((Throwable)e));
                    return "<div class='red'>" + message + "</div>";
                }
            }
        }).setEscapeModelStrings(false).add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"p8p"))}) : (ScriptEngine.instance.interpolative(this.getTitle()) ? new Label(componentId, "<div class='red'>Message contains script but it is created by not trusted user.</div>").setEscapeModelStrings(false).add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"p8p"))}) : new Label(componentId, this.getMessage()).setEscapeModelStrings(false).add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"p8p"))}));
        if (this.refreshInterval != 0) {
            body.setOutputMarkupId(true);
            body.add(new Behavior[]{new AjaxSelfUpdatingTimerBehavior(Duration.seconds((int)this.refreshInterval))});
        }
        return body;
    }
}

