/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.stepsupport.RepositoryStep;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.web.component.MultilineText;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.wicket.Component;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Label", category={"Repository"}, description="Create label on specified repository")
@ScriptApi(value="Label specified repository.")
public class LabelStep
extends RepositoryStep {
    private static final long serialVersionUID = 1L;
    private String label = "${build.version}";
    private String comment;

    @Editable(name="Repository", order=500, description="Choose repository to label. If left empty, all repositories that have been checked out will be labeled.")
    @ChoiceProvider(value="getAvailableRepositoryNames")
    @ScriptApi(value="Get name of the repository to label. If null, all repositories that have been checked out will be labeled.")
    public String getRepositoryName() {
        return super.getRepositoryName();
    }

    @Editable(order=1010, name="Label Name", description="Specify name of the label which will be created on above repository")
    @Expressions(value={"build version", "${build.version}", "build version (CVS compatible)", "${current.convertToCvsLabel(build.version)}"})
    @NotEmpty
    @ScriptApi(value="Get name of the label.")
    @Scriptable
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Editable(order=1020, description="Specify a comment for this label")
    @Scriptable
    @ScriptApi(value="Get comment of the label. Null if not specified.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void run() {
        if (this.getRepositoryName() != null) {
            Repository repository = this.getRepository();
            if (this.getComment() != null) {
                repository.label(this.getLabel(), this.getComment());
            } else {
                repository.label(this.getLabel(), "label created by QuickBuild");
            }
            this.getRuntime().setCustomData((Object)("label revision: " + repository.getRevision().toString()));
        } else {
            HashMap<String, String> revisions = new HashMap<String, String>();
            for (Repository repository : Context.getBuild().getRepositories()) {
                if (!repository.isCheckout()) continue;
                if (this.getComment() != null) {
                    repository.label(this.getLabel(), this.getComment());
                } else {
                    repository.label(this.getLabel(), "label created by QuickBuild");
                }
                revisions.put(repository.getName(), repository.getRevision().toString());
            }
            if (revisions.isEmpty()) {
                this.getRuntime().setCustomData((Object)"No repository to label.");
            } else if (revisions.size() == 1) {
                this.getRuntime().setCustomData((Object)("Label revision: " + (String)revisions.values().iterator().next()));
            } else {
                StringBuffer buffer = new StringBuffer();
                for (Map.Entry entry : revisions.entrySet()) {
                    buffer.append("Label revision of '" + (String)entry.getKey() + "': " + (String)entry.getValue() + "\n");
                }
                this.getRuntime().setCustomData((Object)StringUtils.stripEnd((String)buffer.toString(), (String)"\n"));
            }
        }
    }

    public Component renderCustomRuntimeData(String panelId, Object customRuntimeData) {
        return new MultilineText(panelId, (String)customRuntimeData);
    }

    @ScriptApi(value="Convert specified string to a CVS compatible label.")
    public String convertToCvsLabel(String string) {
        String label = StringUtils.replaceChars((String)StringUtils.replaceChars((String)string.trim(), (char)'.', (char)'_'), (char)',', (char)'_').replaceAll("[\\s]", "-");
        if (!label.matches("^[a-zA-Z].*")) {
            label = "v" + label;
        }
        return label;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
            versions.push(0);
        }
    }
}

