/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.plugin.basis.web.HttpPanel;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.web.page.BasePage;
import com.pmease.quickbuild.web.page.dashboard.DashboardPage;
import java.io.Serializable;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Editable(name="URL Content", order=100000, category={"Others"})
public class HttpGadget
extends Gadget {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(HttpGadget.class);
    private String url;
    private int refreshInterval;

    @Editable(name="URL", order=100, description="Specify a URL to display.")
    @NotEmpty
    @Multiline
    @Scriptable
    public String getUrl() {
        return this.url;
    }

    public String getCssClass() {
        return "window";
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Editable(name="Refresh Interval", order=200, description="Specify auto-refresh interval in seconds for this gadget. Auto refresh will be disabled if this value is set to <tt>0</tt>.")
    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public Component renderBody(String componentId) {
        DashboardPage page = (DashboardPage)BasePage.get();
        if (SecurityHelper.isScriptAllowed((User)page.getActiveDashboard().getUser())) {
            try {
                String interpolated = ScriptEngine.instance.interpolate(this.getUrl(), Context.buildEvalContext(null, null));
                return new HttpPanel(componentId, interpolated, this.getRefreshInterval());
            }
            catch (Exception e) {
                logger.error("Error interpolating URL.", (Throwable)e);
                String interpolated = StringEscapeUtils.escapeHtml((String)ExceptionUtils.extractImportantMessage((Throwable)e));
                return new Label(componentId, "<div class='red'>" + interpolated + "</div>").setEscapeModelStrings(false).add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"p8p"))});
            }
        }
        if (ScriptEngine.instance.interpolative(this.getTitle())) {
            return new Label(componentId, "<div class='red'>URL contains script but it is created by not trusted user.</div>").setEscapeModelStrings(false).add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"p8p"))});
        }
        return new HttpPanel(componentId, this.getUrl(), this.getRefreshInterval());
    }
}

