/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.MiscUtils;
import com.pmease.quickbuild.util.Pair;
import java.io.File;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.taskdefs.FixCRLF;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;

@Editable(name="Fix Line End", category={"Misc"}, description="Fix line end characters of specified text files to conform to current platform")
@ScriptApi(value="Fix line end characters of specified text files to conform to current platform.")
public class FixLineEndStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String sourcePath;
    private String filePatterns;

    @Editable(order=1000, name="Source Directory", description="Specify the directory containing the files to be fixed. An non-absolute path will be considered to be relative to current workspace directory. If left empty, the workspace directory itself will be used.")
    @ScriptApi(value="Get source path under which to fix files. Null will be returned if fix files under workspace directory.")
    @Scriptable
    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    @Editable(order=1100, name="Files To Fix", description="Specify patterns of files that need to be fixed. Patterns will be matched under the <code>source directory</code> specified above.<b>NOTE:</b> refer to <a href=\"$docroot/File+Pattern+Reference\">the file patterns reference</a> for details of the file patterns.")
    @Expressions(value={"all files (recursively)", "**", "all files (non-recursively)", "*"})
    @NotEmpty
    @ScriptApi(value="Get patterns of files to fix.")
    @Scriptable
    public String getFilePatterns() {
        return this.filePatterns;
    }

    public void setFilePatterns(String filePatterns) {
        this.filePatterns = filePatterns;
    }

    public void run() {
        FixCRLF fixCRLF = new FixCRLF();
        fixCRLF.setProject(MiscUtils.createAntProject((Logger)Context.getLogger()));
        if (this.getSourcePath() == null) {
            fixCRLF.setSrcdir(Context.getConfiguration().getWorkspaceDir());
        } else if (new File(this.getSourcePath()).isAbsolute()) {
            fixCRLF.setSrcdir(new File(this.getSourcePath()));
        } else {
            fixCRLF.setSrcdir(new File(Context.getConfiguration().getWorkspaceDir(), this.getSourcePath()));
        }
        Pair includesExcludes = FileUtils.getIncludesExcludes((String)this.getFilePatterns());
        if (((String[])includesExcludes.getFirst()).length != 0) {
            fixCRLF.setIncludes(StringUtils.join((Object[])((Object[])includesExcludes.getFirst()), (String)","));
        }
        if (((String[])includesExcludes.getSecond()).length != 0) {
            fixCRLF.setExcludes(StringUtils.join((Object[])((Object[])includesExcludes.getSecond()), (String)","));
        }
        fixCRLF.execute();
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
        }
    }
}

