/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis;

import com.pmease.quickbuild.annotation.ConfigurationPath;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.extensionpoint.support.Gadget;
import com.pmease.quickbuild.extensionpoint.support.GadgetErrorPanel;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.basis.web.FailedBuildsPanel;
import com.pmease.quickbuild.web.page.BasePage;
import org.apache.wicket.Component;

@Editable(name="Failed Builds", order=600, category={"Configuration and Build"})
public class FailedBuildsGadget
extends Gadget {
    private static final long serialVersionUID = 1L;
    private String treeRoot;

    @Editable(order=100, description="Specify configuration path of the tree root to monitor failed builds under.Leave empty to monitor failed builds of all accessible configurations in the system.")
    @ConfigurationPath
    public String getTreeRoot() {
        return this.treeRoot;
    }

    public void setTreeRoot(String treeRoot) {
        this.treeRoot = treeRoot;
    }

    public String getCssClass() {
        return "window";
    }

    public Component renderBody(String componentId) {
        if (this.getTreeRoot() != null) {
            Configuration parent = BasePage.get().getConfiguration(this.treeRoot);
            if (parent != null) {
                return new FailedBuildsPanel(componentId, parent);
            }
            return new GadgetErrorPanel(componentId, "Can not find configuration '" + this.getTreeRoot() + "'.");
        }
        return new FailedBuildsPanel(componentId, null);
    }
}

