/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Property;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Advanced;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.execution.Commandline;
import com.pmease.quickbuild.execution.LineConsumer;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.Constants;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.StringUtils;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.tools.ant.types.Environment;
import org.dom4j.Element;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Command Line Execution", order=500, category={"Build"}, description="This is almost the same as Shell/Batch Command except that the command will be executed directly by underlying OS, without first wrapping inside a Windows batch or shell script.")
@ScriptApi(value="Build with command line.")
public class CommandlineBuildStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String command;
    private String workingPath;
    private List<Property> environments = new ArrayList<Property>();
    private boolean waitForFinish = true;
    private ErrorDetection errorDetection;
    int returnCode;

    protected File getWorkingDir() {
        return FileUtils.resolvePath((File)Context.getConfiguration().getWorkspaceDir(), (String)this.getWorkingPath());
    }

    @Editable(order=1000, description="Specify the shell or batch commands to be executed. For example: <b>/path/to/command ${build.version}</b>.<br><strong>NOTE:</strong> Command or argument containing spaces should be quoted in order not to be interpreted as multiple arguments.")
    @NotEmpty
    @ScriptApi(value="Get build command.")
    @Scriptable
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @Editable(order=1100, name="Working Directory", description="Optionally specify working directory of the command. A non-absolute path is considered to be relative to the workspace directory. If not specified, current workspace will be used as working directory.<br><b>IMPORTANT:</b> As the name indicates, this property is only used as working directory of the command, and it does not affect the PATH environment which is used to search the command.")
    @ScriptApi(value="Get working directory of the command. Null if current workspace directory is used as working directory.")
    @Scriptable
    public String getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(String workingPath) {
        this.workingPath = workingPath;
    }

    @Editable(name="Environment Variables", order=1200, description="Specify environment variables for command execution. For example, you may store version of current build into environment variable <i>buildVersion</i> by specifying variable name as <i>buildVersion</i> and variable value as <i>${build.version}</code></i>.<br><b>NOTE:</b> Environment variables with blank value will be ignored.")
    @ScriptApi(value="Get defined environment variables when executing the build command.")
    public List<Property> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(List<Property> environments) {
        this.environments = environments;
    }

    @Editable(order=1210, description="Whether or not to wait for finishing of this command.")
    @ScriptApi(value="Whether or not to wait for finishing of the command.")
    @Advanced
    public boolean isWaitForFinish() {
        return this.waitForFinish;
    }

    public void setWaitForFinish(boolean waitForFinish) {
        this.waitForFinish = waitForFinish;
    }

    @Editable(order=1300, name="Detect Errors", description="Check this to tell QuickBuild how to detect errors in the command output. If errors are detected, QuickBuild will fail the step even if the command completes with a zero return code. This setting only takes effect if the \"wait for finish\" option is checked.")
    @ScriptApi(value="Get error detection setting. Null if error detection is not enabled.")
    public ErrorDetection getErrorDetection() {
        return this.errorDetection;
    }

    public void setErrorDetection(ErrorDetection errorDetection) {
        this.errorDetection = errorDetection;
    }

    @ScriptApi(value="Get return code of the command.")
    public int getReturnCode() {
        return this.returnCode;
    }

    public void run() {
        Commandline cmdline = new Commandline();
        String[] parts = StringUtils.parseQuoteTokens((String)this.getCommand());
        cmdline.setExecutable(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            cmdline.createArgument().setValue(parts[i]);
        }
        List actualEnvironments = this.getActualEnvironments(this.getEnvironments());
        if (this.isWaitForFinish()) {
            Environment env = new Environment();
            for (Property each : actualEnvironments) {
                if (!StringUtils.isNotBlank((String)each.getValue())) continue;
                Environment.Variable var = new Environment.Variable();
                var.setKey(each.getName());
                var.setValue(each.getValue());
                env.addVariable(var);
            }
            final StringBuffer errorMessages = new StringBuffer();
            final ArrayList<Pattern> beginIncludePatterns = new ArrayList<Pattern>();
            final ArrayList<Pattern> beginExcludePatterns = new ArrayList<Pattern>();
            final ArrayList<Pattern> endIncludePatterns = new ArrayList<Pattern>();
            final ArrayList<Pattern> endExcludePatterns = new ArrayList<Pattern>();
            if (this.getErrorDetection() != null) {
                for (String each : StringUtils.split((String)this.getErrorDetection().getBeginPatterns(), (String)"\n")) {
                    if (each.trim().length() == 0) continue;
                    if (each.trim().startsWith("+")) {
                        beginIncludePatterns.add(Pattern.compile(each.trim().substring(1)));
                        continue;
                    }
                    if (each.trim().startsWith("-")) {
                        beginExcludePatterns.add(Pattern.compile(each.trim().substring(1)));
                        continue;
                    }
                    beginIncludePatterns.add(Pattern.compile(each.trim()));
                }
                if (this.getErrorDetection().getEndPatterns() != null) {
                    for (String each : StringUtils.split((String)this.getErrorDetection().getEndPatterns(), (String)"\n")) {
                        if (each.trim().length() == 0) continue;
                        if (each.trim().startsWith("+")) {
                            endIncludePatterns.add(Pattern.compile(each.trim().substring(1)));
                            continue;
                        }
                        if (each.trim().startsWith("-")) {
                            endExcludePatterns.add(Pattern.compile(each.trim().substring(1)));
                            continue;
                        }
                        endIncludePatterns.add(Pattern.compile(each.trim()));
                    }
                }
            }
            final boolean[] inError = new boolean[]{false};
            Commandline.ExecuteResult result = cmdline.execute(this.getWorkingDir(), env, (OutputStream)new LineConsumer(){

                private boolean matches(String line, List<Pattern> includePatterns, List<Pattern> excludePatterns) {
                    for (Pattern each : excludePatterns) {
                        if (!each.matcher(line).find()) continue;
                        return false;
                    }
                    for (Pattern each : includePatterns) {
                        if (!each.matcher(line).find()) continue;
                        return true;
                    }
                    return false;
                }

                public void consume(String line) {
                    if (!inError[0]) {
                        if (this.matches(line, beginIncludePatterns, beginExcludePatterns)) {
                            inError[0] = true;
                            if (errorMessages.length() != 0) {
                                errorMessages.append("\n").append(line);
                            } else {
                                errorMessages.append(line);
                            }
                            Context.getLogger().error(line);
                            if (endIncludePatterns.isEmpty() && endExcludePatterns.isEmpty() || this.matches(line, endIncludePatterns, endExcludePatterns)) {
                                inError[0] = false;
                            }
                        } else {
                            Context.getLogger().info(line);
                        }
                    } else {
                        if (errorMessages.length() != 0) {
                            errorMessages.append("\n").append(line);
                        } else {
                            errorMessages.append(line);
                        }
                        Context.getLogger().error(line);
                        if (this.matches(line, endIncludePatterns, endExcludePatterns)) {
                            inError[0] = false;
                        }
                    }
                }
            }, (LineConsumer)(this.getErrorDetection() != null ? null : new LineConsumer.WarnLogger()), Constants.LINE_SEPARATOR);
            this.returnCode = result.getReturnCode();
            if (errorMessages.length() != 0) {
                throw new QuickbuildException(errorMessages.toString());
            }
            if (this.getErrorDetection() == null ? this.returnCode != 0 : this.getErrorDetection().isRespectReturnCode() && this.returnCode != 0) {
                throw result.buildException();
            }
        } else {
            Environment env = new Environment();
            for (Property each : actualEnvironments) {
                Environment.Variable var = new Environment.Variable();
                var.setKey(each.getName());
                var.setValue(each.getValue());
                env.addVariable(var);
            }
            cmdline.executeWithoutWait(this.getWorkingDir(), env);
        }
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        Element element = dom.getRootElement().element("dirToRunCommand");
        if (element != null) {
            element.detach();
            dom.getRootElement().addElement("workingPath").setText(element.getTextTrim());
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        Element root = dom.getRootElement();
        root.element("commandSuccessCondition").detach();
        root.element("environmentVariables").setName("environments");
        if (!versions.empty()) {
            versions.pop();
        } else {
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate3(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("waitForFinish").setText("true");
    }

    private void migrate4(VersionedDocument dom, Stack<Integer> versions) {
        Element respectReturnCodeElement;
        Element errorDetectionElement = dom.getRootElement().element("errorDetection");
        if (errorDetectionElement != null && (respectReturnCodeElement = errorDetectionElement.element("respectReturnCode")) == null) {
            errorDetectionElement.addElement("respectReturnCode").setText("true");
        }
    }

    @ScriptApi
    public static class ErrorDetection
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String beginPatterns;
        private String endPatterns;
        private boolean respectReturnCode = true;

        @Editable(order=10, description="Specify begin patterns of the error, with one <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">pattern</a> per line. These patterns will be searched in each output line, and error message recording will start if one of the patterns matches any part of the line, and stop until one of the end patterns specified below is found. Please note that if a pattern starts with '-', it will be considered as an exclude pattern, which means that the line should not contain this pattern.")
        @Multiline
        @NotEmpty
        @ScriptApi(value="Get begin patterns. Never returns null.")
        @Scriptable
        public String getBeginPatterns() {
            return this.beginPatterns;
        }

        public void setBeginPatterns(String beginPatterns) {
            this.beginPatterns = beginPatterns;
        }

        @Editable(order=20, description="Specify end patterns for error messages. If not specified, it will take the same value as the begin patterns.")
        @Multiline
        @ScriptApi(value="Get end patterns. Null if not specified.")
        @Scriptable
        public String getEndPatterns() {
            return this.endPatterns;
        }

        public void setEndPatterns(String endPatterns) {
            this.endPatterns = endPatterns;
        }

        @Editable(order=30, description="Whether or not to respect return code of the command. If yes, the command is considered failed if return code is not zero even if no error pattern is detected.")
        public boolean isRespectReturnCode() {
            return this.respectReturnCode;
        }

        public void setRespectReturnCode(boolean respectReturnCode) {
            this.respectReturnCode = respectReturnCode;
        }
    }
}

