/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.basis;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.util.MiscUtils;
import com.pmease.quickbuild.util.Pair;
import java.io.File;
import java.util.Stack;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;

@Editable(name="Change File Permission", category={"Misc"}, description="Change permissions of specified files on UNIX-like platforms.")
@ScriptApi(value="Change permission of specified files.")
public class ChangePermissionStep
extends Step {
    private static final long serialVersionUID = 1L;
    private String sourcePath;
    private String filePatterns;
    private String permissions;
    private int maxParallel = 1000;

    @Editable(order=1000, name="Source Directory", description="Specify the directory containing the files to change permissions. An non-absolute path will be considered to be relative to current workspace directory. If left empty, the workspace directory itself will be used.")
    @ScriptApi(value="Get source path under which to change file permissions. Null if under workspace directory.")
    @Scriptable
    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    @Editable(order=1100, name="Files To Change", description="Specify patterns of files whose permissions need to be changed. Patterns will be matched under the <i>source directory</i> specified above.<b>NOTE:</b> refer to <a href=\"$docroot/File+Pattern+Reference\">the file patterns reference</a> for details of the file patterns.")
    @Expressions(value={"all files (recursively)", "**", "all files (non-recursively)", "*"})
    @NotEmpty
    @ScriptApi(value="Get patterns of files to change permissions.")
    @Scriptable
    public String getFilePatterns() {
        return this.filePatterns;
    }

    public void setFilePatterns(String filePatterns) {
        this.filePatterns = filePatterns;
    }

    @Editable(order=1200, description="Specify permission string to set. For example, <em>700</em>, <em>ugo+rx</em>, etc.")
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get new permissions of files.")
    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    @Editable(order=1250, description="QuickBuild internally calls OS chmod command to do the job, and this setting specifies maximum number of files to be passed to that command. When there are a lot of files to be processed, a large value for this setting can dramatically increase the speed. However your system might has a limit on total length of the command to be executed, and in this case you will need to decrease this setting. Specifically, zero value means unlimited.")
    public int getMaxParallel() {
        return this.maxParallel;
    }

    public void setMaxParallel(int maxParallel) {
        this.maxParallel = maxParallel;
    }

    public void run() {
        Chmod chmod = new Chmod();
        FileSet fileset = new FileSet();
        chmod.setProject(MiscUtils.createAntProject((Logger)Context.getLogger()));
        if (this.getSourcePath() == null) {
            fileset.setDir(Context.getConfiguration().getWorkspaceDir());
        } else if (new File(this.getSourcePath()).isAbsolute()) {
            fileset.setDir(new File(this.getSourcePath()));
        } else {
            fileset.setDir(new File(Context.getConfiguration().getWorkspaceDir(), this.getSourcePath()));
        }
        fileset.setProject(chmod.getProject());
        Pair includesExcludes = FileUtils.getIncludesExcludes((String)this.getFilePatterns());
        fileset.appendIncludes((String[])includesExcludes.getFirst());
        fileset.appendExcludes((String[])includesExcludes.getSecond());
        chmod.setMaxParallel(this.getMaxParallel());
        chmod.addFileset(fileset);
        chmod.setPerm(this.getPermissions());
        chmod.execute();
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        if (versions.empty()) {
            versions.push(0);
            versions.push(0);
        }
    }

    private void migrate2(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("maxParallel").setText("1000");
    }
}

