/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.bugzilla.step;

import com.google.common.collect.Maps;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.plugin.tracker.bugzilla.BugzillaPlugin;
import com.pmease.quickbuild.plugin.tracker.bugzilla.client.BugzillaClient;
import com.pmease.quickbuild.plugin.tracker.core.AbstractTrackerPlugin;
import com.pmease.quickbuild.plugin.tracker.core.step.AbstractIssueStep;
import com.pmease.quickbuild.plugin.tracker.core.utils.StringHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Create Bugzilla Issue", category={"Issue Tracker"}, description="This step creates a bug/issue in defined Bugzilla server")
public class CreateIssueStep
extends AbstractIssueStep {
    private static final long serialVersionUID = 1L;
    private String product;
    private String component;
    private String summary;
    private String issueDescription;
    private String opsys;
    private String hardware;
    private String severity;
    private String priority;
    private String version;

    @Editable(name="Summary", order=1000)
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get issue summary")
    public String getSummary() {
        return this.summary;
    }

    @Editable(name="Product", order=1100)
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get issue product")
    public String getProduct() {
        return this.product;
    }

    @Editable(name="Component", order=1200)
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get issue component")
    public String getComponent() {
        return this.component;
    }

    @Editable(name="Operation System", order=1300)
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get issue operation system")
    @ExpressionProvider(value="getAvailableOS")
    public String getOpsys() {
        return this.opsys;
    }

    @Editable(name="Hardware", order=1400)
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get issue hardware")
    @ExpressionProvider(value="getAvailableHardware")
    public String getHardware() {
        return this.hardware;
    }

    @Editable(name="Severity", order=1500)
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get issue severity")
    @ExpressionProvider(value="getAvailableSeverity")
    public String getSeverity() {
        return this.severity;
    }

    @Editable(name="Priority", order=1600)
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get issue priority")
    @ExpressionProvider(value="getAvailablePriority")
    public String getPriority() {
        return this.priority;
    }

    @Editable(name="Version", order=1700)
    @Scriptable
    @ScriptApi(value="Get issue target version")
    public String getVersion() {
        return this.version;
    }

    @Editable(name="Description", order=1800)
    @Multiline
    @Scriptable
    @ScriptApi(value="get issue description")
    public String getIssueDescription() {
        return this.issueDescription;
    }

    @Editable(order=1600, name="Extra Attributes", description="Specify extra attributes of the bug, with one attribute per line. For example:<br/><code>field_1=value1<br/>field2=value2</code>Consult your Bugzilla administrator for available attributes.")
    @Multiline
    @Scriptable
    @ScriptApi(value="Get extra attributes which will be used to create bug.")
    public String getExtraAttributes() {
        return super.getExtraAttributes();
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setIssueDescription(String description) {
        this.issueDescription = description;
    }

    public void setOpsys(String opsys) {
        this.opsys = opsys;
    }

    public void setHardware(String hardware) {
        this.hardware = hardware;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setVersion(String issueVersion) {
        this.version = issueVersion;
    }

    public void run() {
        this.onBeforeRun();
        BugzillaClient client = BugzillaClient.newInstance();
        String extraOptions = this.getExtraAttributes();
        HashMap map = Maps.newHashMap((Map)StringHelper.getOptionsFromDefinition((String)extraOptions));
        map.put("product", this.getProduct());
        map.put("component", this.getComponent());
        map.put("summary", this.getSummary());
        map.put("op_sys", this.getOpsys());
        map.put("platform", this.getHardware());
        map.put("severity", this.getSeverity());
        map.put("priority", this.getPriority());
        String version = this.getVersion();
        if (StringUtils.isEmpty((String)version)) {
            version = "unspecified";
        }
        map.put("version", version);
        String description = this.getDescription();
        if (StringUtils.isEmpty((String)description)) {
            description = "";
        }
        map.put("description", description);
        client.login();
        Integer bugId = client.createIssue(map);
        if (bugId == null) {
            throw new QuickbuildException("Create issue [" + this.getSummary() + "] failed!");
        }
        Context.getLogger().info("Issue #" + bugId + " created successfully.");
        this.getIssueActions().put(String.valueOf(bugId), "create");
        this.onAfterRun();
    }

    private static Map<String, String> toProviderMap(String[] array) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String each : array) {
            map.put(each, each);
        }
        return map;
    }

    private static Map<String, String> getAvailableOS() {
        return CreateIssueStep.toProviderMap(new String[]{"All", "Windows", "Linux", "Mac OS", "Other"});
    }

    private static Map<String, String> getAvailableHardware() {
        return CreateIssueStep.toProviderMap(new String[]{"All", "PC", "Macintosh", "Other"});
    }

    private static Map<String, String> getAvailablePriority() {
        return CreateIssueStep.toProviderMap(new String[]{"P1", "P2", "P3", "P4", "P5"});
    }

    private static Map<String, String> getAvailableSeverity() {
        return CreateIssueStep.toProviderMap(new String[]{"blocker", "critical", "major", "normal", "minor", "trivial", "enhancement"});
    }

    public Class<? extends AbstractTrackerPlugin> getPluginClass() {
        return BugzillaPlugin.class;
    }
}

