/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.plugin.tracker.bugzilla.setting;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.plugin.tracker.bugzilla.BugzillaPlugin;
import com.pmease.quickbuild.plugin.tracker.core.setting.AbstractTrackerSetting;
import com.pmease.quickbuild.pluginsupport.PluginSettingHelper;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Bugzilla Server", order=1030, category={"Issue Tracker"})
public class BugzillaSetting
extends AbstractTrackerSetting {
    private static final long serialVersionUID = 1L;
    private String issuePattern;

    public BugzillaSetting() {
        this.issuePattern = "(?<!\\:)(?:#|bug:)\\d+";
    }

    public BugzillaSetting(String host, String user, String password) {
        this.setHost(host);
        this.setUser(user);
        this.setPassword(password);
    }

    @Editable(name="Bugzilla server url", order=100, description="Specify Bugzilla server url. For example: <i>http://bugzilla.example.com</i>")
    @NotEmpty
    @Scriptable
    public String getHost() {
        return super.getHost();
    }

    public static BugzillaSetting get(Configuration configuration) {
        if (configuration == null) {
            return null;
        }
        return (BugzillaSetting)((Object)PluginSettingHelper.findConfigurationSetting(BugzillaPlugin.class, (Configuration)configuration, (boolean)true));
    }

    public static boolean isApplicable(Configuration c) {
        return BugzillaSetting.get(c) != null;
    }

    @Editable(name="Issue Pattern", order=1100, description="Specify <a href=\"http://java.sun.com/j2se/1.5.0/docs/api/java/util/regex/Pattern.html\">pattern</a> of Bugzilla bug keys in SCM commit message. This pattern will be used by QuickBuild to transform bug keys to bug links. The default pattern will recognize <i>#123</i> and <i>bug:123</i> as bug keys while won't recognize <i>:#123</i>.")
    @NotEmpty
    @Scriptable
    @ScriptApi
    public String getIssuePattern() {
        return this.issuePattern;
    }

    public void setIssuePattern(String issuePattern) {
        this.issuePattern = issuePattern;
    }
}

